/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.restrictions.rules;

import org.ametys.odf.program.Program;
import org.ametys.plugins.repository.query.expression.Expression;

/**
 * Interface to represent a rule for an ODF restriction
 */
public interface OdfRestrictionRule
{
    /**
     * Translate the restriction into an expression that can be used for repository query.
     * @return The restriction expression
     */
    public Expression getExpression();
    
    /**
     * Determines if this program is part of this restriction
     * @param program The program
     * @return <code>true</code> If the program is part of this restriction
     */
    public boolean contains(Program program);
    
    /**
     * Indicate if this restriction is related to orgunit
     * @return true if it is the case
     */
    public boolean hasOrgunitRestrictions(); // TODO to remove ?
}
