/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.catalog;

import java.util.Map;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.odfweb.repository.OdfPageResolver;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ExportCatalogByLevelsGenerator
extends org.ametys.odf.export.ExportCatalogByLevelsGenerator {
    protected OdfPageHandler _odfPageHandler;
    protected OdfPageResolver _odfPageResolver;
    protected SiteManager _siteManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._odfPageHandler = (OdfPageHandler)((Object)smanager.lookup(OdfPageHandler.ROLE));
        this._odfPageResolver = (OdfPageResolver)((Object)smanager.lookup(OdfPageResolver.ROLE));
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
    }

    protected boolean getParameters(Map<String, String> wsParameters) throws SAXException {
        boolean isValidParameters;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String site = this.getParameter(request, "site");
        wsParameters.put("site", site);
        String catalog = this.getParameter(request, "catalog");
        wsParameters.put("catalog", catalog);
        String lang = this.getParameter(request, "lang");
        wsParameters.put("lang", lang);
        String metadataSet = request.getParameter("metadataSet");
        if (StringUtils.isBlank((CharSequence)metadataSet)) {
            metadataSet = "main";
        }
        wsParameters.put("metadataSet", metadataSet);
        boolean bl = isValidParameters = site != null && catalog != null && lang != null;
        if (isValidParameters) {
            Page odfRootPage = this._odfPageHandler.getOdfRootPage(site, lang, catalog);
            if (odfRootPage == null) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"error", (String)("No ODF root page on website '" + site + "' for sitemap '" + lang + "' and catalog '" + catalog + "'"));
                isValidParameters = false;
            } else {
                String level1 = request.getParameter("level1");
                String level2 = request.getParameter("level2");
                if (level1 == null || level2 == null) {
                    if (level1 == null) {
                        level1 = this._odfPageHandler.getLevel1Metadata(odfRootPage);
                    }
                    if (level2 == null) {
                        level2 = this._odfPageHandler.getLevel2Metadata(odfRootPage);
                    }
                }
                if (!this._odfClassificationHandler.isEligibleMetadataForLevel(level1, true)) {
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"error", (String)("The metadata " + level1 + " is not an eligible metadata for the export"));
                    isValidParameters = false;
                }
                if (!this._odfClassificationHandler.isEligibleMetadataForLevel(level2, true)) {
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"error", (String)("The metadata " + level2 + " is not an eligible metadata for the export"));
                    isValidParameters = false;
                }
                wsParameters.put("level1", level1);
                wsParameters.put("level2", level2);
            }
        }
        return isValidParameters;
    }

    protected AmetysObjectIterable<Program> getConcernedPrograms(Map<String, String> wsParameters) {
        Page odfRootPage = this._odfPageHandler.getOdfRootPage(wsParameters.get("site"), wsParameters.get("lang"), wsParameters.get("catalog"));
        return this._odfPageHandler.getProgramsWithRestrictions(odfRootPage, wsParameters.get("level1"), null, wsParameters.get("level2"), null, null, null);
    }

    protected AttributesImpl getContentAttributes(ProgramItem programItem, Program parentProgram, Map<String, String> wsParameters) {
        String siteName = wsParameters.get("site");
        String url = this._siteManager.getSite(siteName).getUrl();
        AttributesImpl attrs = super.getContentAttributes(programItem, parentProgram, wsParameters);
        String path = this._odfPageResolver.getProgramItemPagePath(siteName, wsParameters.get("lang"), programItem, parentProgram);
        attrs.addCDATAAttribute("path", url + "/" + path);
        return attrs;
    }
}

