<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:math="http://exslt.org/math"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                xmlns:odf="org.ametys.odf.OdfXSLTHelper"
                extension-element-prefixes="resolver exslt">
    
    <xsl:import href="service:odf-web://pages/services/schema/schema_1.3.xsl"/>
    
    <xsl:variable name="FL" select="odf:getEntryId('odf-enumeration.Degree', 'FL')"/><!-- Odontologie  -->
    <xsl:variable name="CY" select="odf:getEntryId('odf-enumeration.Degree', 'CY')"/><!-- PACES -->
    <xsl:variable name="PE" select="odf:getEntryId('odf-enumeration.Degree', 'PE')"/><!-- Diplôme d’Etat de Sage-femmes  -->
    <xsl:variable name="YL" select="odf:getEntryId('odf-enumeration.Degree', 'YL')"/><!-- Pharmacie -->
    <xsl:variable name="YJ" select="odf:getEntryId('odf-enumeration.Degree', 'YJ')"/><!-- Medecine -->

	 <xsl:template name="common-service-head-css">
	 	<style>
	 		#etudesgenerales {
	 			float:left;
	 		}
	 	</style>
	</xsl:template>

   	<xsl:template name="odf-schema">
    	<div class="odf-schema">
    		<xsl:call-template name="general-studies"/>
    		<xsl:call-template name="health-studies"/>
    	</div>
    </xsl:template>
    
    <xsl:template name="health-studies">
    	<img src="{ametys:pluginResourceURL('odf-web', 'img/services/schema/etu-sante.png')}" id="etudesdesante" usemap="#m_etusante" alt="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_HEALTH_STUDIES"  i18n:attr="alt" height="442" width="154"/>
		<map name="m_etusante" id="m_etusante">
			<area shape="rect" coords="11,343,157,382" title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_PACES" alt="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_PACES" i18n:attr="title alt">
                <xsl:call-template name="get-href"><xsl:with-param name="qs" select="concat('degree=', $CY)" /></xsl:call-template>
            </area>
			<area shape="rect" coords="122,44,157,340" title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DISM" alt="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DISM" i18n:attr="title alt">
                <xsl:call-template name="get-href"><xsl:with-param name="qs" select="concat('degree=', $YJ)" /></xsl:call-template>
            </area>
			<area shape="rect" coords="85,44,119,340" title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DERSO" alt="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DERSO" i18n:attr="title alt">
                <xsl:call-template name="get-href"><xsl:with-param name="qs" select="concat('degree=', $FL)" /></xsl:call-template>
            </area>
			<area shape="rect" coords="48,130,82,340" title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DISP" alt="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DISP" i18n:attr="title alt">
                <xsl:call-template name="get-href"><xsl:with-param name="qs" select="concat('degree=', $YL)" /></xsl:call-template>
            </area>
			<area shape="rect" coords="11,172,44,340" title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DESF" alt="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DESF" i18n:attr="title alt">
                <xsl:call-template name="get-href"><xsl:with-param name="qs" select="concat('degree=', $PE)" /></xsl:call-template>
            </area>
		</map>
    </xsl:template>
    
</xsl:stylesheet>