/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.observation;

import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfweb.observation.AbstractODFObserver;
import org.ametys.web.cache.CacheInvalidationPolicy;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class InvalidateCacheOnContentValidationOrUnpublishingObserver
extends AbstractODFObserver {
    protected CacheInvalidationPolicy _cachePolicy;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._cachePolicy = (CacheInvalidationPolicy)serviceManager.lookup(CacheInvalidationPolicy.class.getName());
    }

    public boolean supports(Event event) {
        return event.getId().equals("content.validated") || event.getId().equals("content.untag.live");
    }

    public int getPriority() {
        return 4000;
    }

    @Override
    protected String _workspaceToUse() {
        return "live";
    }

    @Override
    protected void _internalObserve(Event event, Map<String, Object> transientVars, Page odfRootPage, Set<Program> rootPrograms, SubProgram subProgram, Course course) throws Exception {
        Site site = odfRootPage.getSite();
        for (Program program : rootPrograms) {
            this._invalidate(site, (Content)program);
        }
        if (subProgram != null) {
            this._invalidate(site, (Content)subProgram);
        }
        if (course != null) {
            this._invalidate(site, (Content)course);
        }
    }

    protected void _invalidate(Site site, Content content) {
        try {
            this._cachePolicy.invalidateCacheOnContentModification(site, content);
        }
        catch (Exception e) {
            this.getLogger().error("Unable to invalidate cache for progam {}", (Object)content, (Object)e);
        }
    }
}

