/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.catalog;

import org.ametys.core.util.URIUtils;

/**
 *  Generate the SAX events corresponding to the transformation of a catalogue to a XML file for InDesign for the current site
 */
public class IndesignCatalogueGenerator extends org.ametys.odf.export.indesign.IndesignCatalogueGenerator
{
    @Override
    protected String _getUri(String programId, String xslt)
    {
        String siteName = parameters.getParameter("siteName", null);
        return "cocoon://_plugins/odf-web/" + siteName + "/_indesign/program.xml?id=" + URIUtils.encodeParameter(programId) + "&xslt=" + xslt;
    }
}
