/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.schedulable;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.plugins.core.schedule.Scheduler;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;

/**
 * Override ODF EducationalBookletSchedulable to add the site name in the request
 */
public class EducationalBookletSchedulable extends org.ametys.odf.schedulable.EducationalBookletSchedulable
{
    /** The site manager */
    protected SiteManager _siteManager;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _siteManager = (SiteManager) manager.lookup(SiteManager.ROLE);
    }
    
    @Override
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception
    {
        Request request = ContextHelper.getRequest(_context);
        
        String siteName = _getSiteName(context);
        request.setAttribute("site", siteName);
        request.setAttribute("siteName", siteName);
        
        Site site = _siteManager.getSite(siteName);
        request.setAttribute("skin", site.getSkinId());
        
        super.execute(context, progressionTracker);
    }

    /**
     * Get the site name from the context
     * @param context the context
     * @return the site name
     */
    protected String _getSiteName(JobExecutionContext context)
    {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        return jobDataMap.getString(Scheduler.PARAM_VALUES_PREFIX + "siteName");
    }
}
