/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.service.search;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;

import org.ametys.cms.search.query.Query;
import org.ametys.odf.course.Course;
import org.ametys.odf.course.CourseFactory;
import org.ametys.web.frontoffice.search.metamodel.AdditionalParameterValueMap;
import org.ametys.web.frontoffice.search.metamodel.Returnable;
import org.ametys.web.frontoffice.search.metamodel.SearchServiceCriterionDefinition;
import org.ametys.web.frontoffice.search.metamodel.Searchable;
import org.ametys.web.frontoffice.search.metamodel.impl.AbstractContentBasedSearchable;

/**
 * {@link Searchable} for {@link Course}s
 */
public class CourseSearchable extends AbstractContentBasedSearchable
{
    /** Avalon Role */
    public static final String ROLE = CourseSearchable.class.getName();
    
    private static final String __CRITERION_DEFINITIONS_PREFIX_ID = "CourseSearchable$";
    
    @Override
    protected String associatedContentReturnableRole()
    {
        return CourseReturnable.ROLE;
    }
    
    @Override
    protected String getCriterionDefinitionPrefix()
    {
        return __CRITERION_DEFINITIONS_PREFIX_ID;
    }
    
    @Override
    public Collection<Returnable> relationsWith()
    {
        return Arrays.asList(_associatedContentReturnable);
    }
    
    @Override
    protected Set<String> getContentTypeIds(AdditionalParameterValueMap additionalParameterValues)
    {
        return Set.of(CourseFactory.COURSE_CONTENT_TYPE);
    }
    
    @Override
    public Optional<Query> joinQuery(Query queryOnCriterion, SearchServiceCriterionDefinition criterion, Collection<Returnable> returnables, AdditionalParameterValueMap additionalParameters)
    {
        if (returnables.contains(_associatedContentReturnable))
        {
            return Optional.of(queryOnCriterion);
        }
        else
        {
            return Optional.empty();
        }
    }
}

