/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.inputdata;

import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.translation.TranslationHelper;
import org.ametys.plugins.odfweb.repository.CoursePage;
import org.ametys.plugins.odfweb.repository.OdfPageResolver;
import org.ametys.plugins.odfweb.repository.ProgramPage;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.inputdata.InputData;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TranslationsInputData
extends AbstractLogEnabled
implements InputData,
Serviceable,
Contextualizable {
    protected Context _context;
    protected AmetysObjectResolver _ametysResolver;
    protected OdfPageResolver _odfPageResolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._ametysResolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._odfPageResolver = (OdfPageResolver)((Object)manager.lookup(OdfPageResolver.ROLE));
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public boolean isCacheable(Site site, Page page) {
        return true;
    }

    public void toSAX(ContentHandler handler) throws SAXException, ProcessingException {
        Request request = ContextHelper.getRequest((Context)this._context);
        Page page = (Page)request.getAttribute(Page.class.getName());
        handler.startDocument();
        XMLUtils.startElement((ContentHandler)handler, (String)"translations");
        if (page instanceof ProgramPage) {
            AbstractProgram program = ((ProgramPage)page).getProgram();
            Map translations = TranslationHelper.getTranslations((Content)program);
            this._saxTranslations(handler, translations);
        } else if (page instanceof CoursePage) {
            Course course = ((CoursePage)page).getCourse();
            Map translations = TranslationHelper.getTranslations((Content)course);
            this._saxTranslations(handler, translations);
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"translations");
        handler.endDocument();
    }

    private void _saxTranslations(ContentHandler contentHandler, Map<String, String> translations) throws SAXException {
        for (String lang : translations.keySet()) {
            String contentId = translations.get(lang);
            try {
                Content translatedProgram = (Content)this._ametysResolver.resolveById(contentId);
                AttributesImpl attrs = new AttributesImpl();
                attrs.addCDATAAttribute("language", lang);
                attrs.addCDATAAttribute("id", translatedProgram.getId());
                XMLUtils.createElement((ContentHandler)contentHandler, (String)"translation", (Attributes)attrs);
            }
            catch (UnknownAmetysObjectException unknownAmetysObjectException) {}
        }
    }
}

