/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.content;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.runtime.config.Config;
import org.ametys.web.content.sitegetter.AbstractSiteGetter;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;

/**
 * Extension point linking a website to a content.
 */
public class ODFWebSiteGetter extends AbstractSiteGetter implements Serviceable
{
    /** The site manager */
    protected SiteManager _siteManager;
    /** Content types helper */
    protected ContentTypesHelper _cTypeHelper;

    public void service(ServiceManager manager) throws ServiceException
    {
        _siteManager = (SiteManager) manager.lookup(SiteManager.ROLE);
        _cTypeHelper = (ContentTypesHelper) manager.lookup(ContentTypesHelper.ROLE);
    }
    
    @Override
    public boolean supports(Content content)
    {
        return _cTypeHelper.isInstanceOf(content, "org.ametys.plugins.odf.Content.odfContent");
    }

    @Override
    public Site getSite(Content content)
    {
        String siteName = Config.getInstance().getValue("odf.web.site.name");
        return _siteManager.getSite(siteName);
    }
}
