/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfweb.repository.AbstractOdfPage;
import org.ametys.plugins.odfweb.repository.FirstLevelPage;
import org.ametys.plugins.odfweb.repository.ProgramPage;
import org.ametys.plugins.odfweb.repository.SecondLevelPageFactory;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.MemoryRepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.virtual.VirtualPageConfiguration;

public class SecondLevelPage
extends AbstractOdfPage<SecondLevelPageFactory> {
    private String _name;
    private String _title;
    private String _level1;
    private FirstLevelPage _level1Page;

    public SecondLevelPage(Page root, VirtualPageConfiguration configuration, SecondLevelPageFactory factory, String level1Key, String name, String title, FirstLevelPage firstLevelPage) {
        super(root, configuration, factory.getScheme(), factory);
        this._name = name;
        this._title = title;
        this._level1 = level1Key;
        this._level1Page = firstLevelPage;
    }

    public int getDepth() throws AmetysRepositoryException {
        return this._root.getDepth() + 2;
    }

    public String getTitle() throws AmetysRepositoryException {
        return this._title;
    }

    public String getLongTitle() throws AmetysRepositoryException {
        return this.getParent().getTitle() + " - " + this._title;
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages() throws AmetysRepositoryException {
        List pages = this._getChildrenFromCache().orElseGet(() -> ((SecondLevelPageFactory)this._factory).getODFPageHandler().getProgramsWithRestrictions(this._root, this._level1, this._name, null, null)).stream().map(this::_createProgramPage).collect(Collectors.toList());
        return new CollectionIterable(pages);
    }

    private Optional<AmetysObjectIterable<Program>> _getChildrenFromCache() {
        return Optional.ofNullable(((SecondLevelPageFactory)this._factory).getODFPageCache().getProgramCache(this._root, false)).map(firstLevelCache -> (Map)firstLevelCache.get(this._level1)).map(secondLevelCache -> (Collection)secondLevelCache.get(this._name)).map(CollectionIterable::new);
    }

    private ProgramPage _createProgramPage(Program program) {
        return ((SecondLevelPageFactory)this._factory).getProgramPageFactory().createProgramPage(this._root, (AbstractProgram)program, null, null, (Page)this);
    }

    public String getPathInSitemap() throws AmetysRepositoryException {
        return this._root.getPathInSitemap() + "/" + this.getParent().getName() + "/" + this.getName();
    }

    public <A extends AmetysObject> A getChild(String path) throws AmetysRepositoryException, UnknownAmetysObjectException {
        return (A)((SecondLevelPageFactory)this._factory).getODFPageCache().getChildProgramPage(this._root, (Page)this, this._level1, this._name, path);
    }

    public boolean hasChild(String name) throws AmetysRepositoryException {
        return ((SecondLevelPageFactory)this._factory).getODFPageCache().getProgramFromPageName(this._root, this._level1, this._name, name).isPresent();
    }

    public String getId() throws AmetysRepositoryException {
        return ((SecondLevelPageFactory)this._factory).getODFPageHandler().buildLevel2Id(this._root, this._level1, this._name);
    }

    public String getName() throws AmetysRepositoryException {
        return NameHelper.filterName((String)this._title) + "-" + ((SecondLevelPageFactory)this._factory).getODFPageHandler().encodeLevelValue(this._name);
    }

    public Page getParent() throws AmetysRepositoryException {
        if (this._level1Page == null) {
            this._level1Page = ((SecondLevelPageFactory)this._factory).getODFPageHandler().findFirstLevelPage(this._root, this._level1);
        }
        return this._level1Page;
    }

    public String getParentPath() throws AmetysRepositoryException {
        return this._root.getPath() + "/" + this.getParent().getName();
    }

    public ModelLessDataHolder getDataHolder() {
        MemoryRepositoryData repositoryData = new MemoryRepositoryData(this.getName());
        return new DefaultModelLessDataHolder((ModelItemTypeExtensionPoint)((SecondLevelPageFactory)this._factory).getPageDataTypeEP(), (RepositoryData)repositoryData);
    }
}

