/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.repository;

import com.google.common.base.Splitter;
import java.util.Map;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfweb.repository.AbstractOdfPageFactory;
import org.ametys.plugins.odfweb.repository.ProgramPage;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.web.repository.page.Page;
import org.apache.commons.lang3.StringUtils;

public class ProgramPageFactory
extends AbstractOdfPageFactory
implements AmetysObjectFactory<ProgramPage> {
    public ProgramPage createProgramPage(Page root, AbstractProgram program, String path, Program parent, Page parentPage) {
        return new ProgramPage(root, this.getConfiguration(), this, program, path, parent, parentPage);
    }

    public ProgramPage getAmetysObjectById(String id) throws AmetysRepositoryException {
        String path = StringUtils.substringBetween((String)id, (String)"://", (String)"?");
        String queryString = StringUtils.substringAfter((String)id, (String)"?");
        Map ids = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)queryString);
        String rootId = (String)ids.get("rootId");
        String programId = (String)ids.get("programId");
        String parentId = (String)ids.get("parentId");
        if ("_root".equals(path)) {
            path = null;
        }
        Page root = (Page)this._resolver.resolveById(rootId);
        AbstractProgram program = (AbstractProgram)this._resolver.resolveById(programId);
        Program parent = StringUtils.isNotEmpty((CharSequence)parentId) ? (Program)this._resolver.resolveById(parentId) : null;
        Program parentProgramOrSelf = this._getParentProgramOrSelf(parent, program);
        if (parentProgramOrSelf == null) {
            throw new UnknownAmetysObjectException("The object '" + program.getId() + "' is not a Program and its given parent is null.");
        }
        if (!this._odfPageHandler.isValidRestriction(root, parentProgramOrSelf)) {
            throw new UnknownAmetysObjectException("There's no program child page " + programId + " for site " + root.getSiteName());
        }
        try {
            ProgramPage programPage = this.createProgramPage(root, program, path, parent, null);
            programPage.getPathInSitemap();
            return programPage;
        }
        catch (UnknownAmetysObjectException e) {
            throw new UnknownAmetysObjectException("There's no program child page " + programId + " for site " + root.getSiteName(), (Throwable)e);
        }
    }

    private Program _getParentProgramOrSelf(Program parent, AbstractProgram self) throws UnknownAmetysObjectException {
        if (parent != null) {
            return parent;
        }
        if (self instanceof Program) {
            return (Program)self;
        }
        return null;
    }

    public String getScheme() {
        return "program";
    }

    public boolean hasAmetysObjectForId(String id) throws AmetysRepositoryException {
        int i = id.indexOf(63);
        String queryString = id.substring(i + 1);
        Map ids = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)queryString);
        String rootId = (String)ids.get("rootId");
        String programId = (String)ids.get("programId");
        String parentId = (String)ids.get("parentId");
        if (!this._resolver.hasAmetysObjectForId(rootId) || !this._resolver.hasAmetysObjectForId(programId)) {
            return false;
        }
        Page root = (Page)this._resolver.resolveById(rootId);
        AbstractProgram program = (AbstractProgram)this._resolver.resolveById(programId);
        Program parent = StringUtils.isNotEmpty((CharSequence)parentId) ? (Program)this._resolver.resolveById(parentId) : null;
        Program parentProgramOrSelf = this._getParentProgramOrSelf(parent, program);
        if (parentProgramOrSelf == null) {
            return false;
        }
        if (!this._odfPageHandler.isValidRestriction(root, parentProgramOrSelf)) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)this._odfPageHandler.getLevel2Metadata(root))) {
            return this._odfPageHandler.getProgramLevel1Value(root, parentProgramOrSelf) != null && this._odfPageHandler.getProgramLevel2Value(root, parentProgramOrSelf) != null;
        }
        if (StringUtils.isNotBlank((CharSequence)this._odfPageHandler.getLevel1Metadata(root))) {
            return this._odfPageHandler.getProgramLevel1Value(root, parentProgramOrSelf) != null;
        }
        return true;
    }
}

