/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.service.search;

import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Optional;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.DateUtils;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.plugins.odfweb.repository.CoursePage;
import org.ametys.plugins.odfweb.service.search.CourseReturnable;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.web.frontoffice.search.metamodel.impl.PageReturnable;
import org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer;
import org.ametys.web.frontoffice.search.requesttime.SearchComponentArguments;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.slf4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CourseSaxer
extends PageSaxer {
    private CourseReturnable _courseReturnable;

    public CourseSaxer(PageReturnable pageReturnable, CourseReturnable courseReturnable) {
        super(pageReturnable);
        this._courseReturnable = courseReturnable;
    }

    public boolean canSax(AmetysObject hit, Logger logger, SearchComponentArguments args) {
        return hit instanceof Course;
    }

    public void sax(ContentHandler contentHandler, AmetysObject hit, Logger logger, SearchComponentArguments args) throws SAXException {
        Course course = (Course)hit;
        this._saxCourseContent(contentHandler, course, logger, args);
        Optional<CoursePage> coursePage = this._resolveCoursePage(course, args.currentSite());
        if (coursePage.isPresent()) {
            Page page = (Page)coursePage.get();
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"uri", (String)(page.getSitemap().getName() + "/" + page.getPathInSitemap()));
        }
    }

    private Optional<CoursePage> _resolveCoursePage(Course course, Site currentSite) {
        return Optional.of(this._courseReturnable._odfPageResolver).map(res -> res.getCoursePage(course, (AbstractProgram)null, currentSite.getName()));
    }

    private void _saxCourseContent(ContentHandler contentHandler, Course course, Logger logger, SearchComponentArguments args) throws SAXException {
        XMLUtils.createElement((ContentHandler)contentHandler, (String)"title", (String)course.getTitle());
        ZonedDateTime lastValidationDate = course.getLastValidationDate();
        if (lastValidationDate != null) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"lastValidation", (String)DateUtils.zonedDateTimeToString((ZonedDateTime)lastValidationDate));
        }
        Locale locale = LocaleUtils.toLocale((String)args.currentPage().getSitemapName());
        this.saxContent((Content)course, "index", locale, contentHandler, logger);
    }
}

