/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.observation;

import java.util.Map;
import java.util.Set;

import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;

/**
 * {@link Observer} for observing skills exclusion update in order to invalidate cache on front-office.
 */
public class InvalidateCacheOnSkillsExclusionChangedObserver extends InvalidateCacheOnContentValidationOrUnpublishingObserver
{
    @Override
    public boolean supports(Event event)
    {
        return event.getId().equals(org.ametys.odf.observation.OdfObservationConstants.ODF_CONTENT_SKILLS_EXCLUSION_CHANGED);
    }
    
    @Override
    protected void _internalObserve(Event event, Map<String, Object> transientVars, Page odfRootPage, Set<Program> rootPrograms, SubProgram subProgram, Course course) throws Exception
    {
        Content content = _getContentArgument(event);
        
        if (content instanceof ProgramItem)
        {
            Site site = odfRootPage.getSite();
            _invalidate(site, content);
            
            // IMPORTANT NOTE
            // Changing visibility can change rendering of child subprogram/course and parent program/subprogram
            // In theory we should compute and invalidate the cache of parent and child pages
            // But given the current implementation of invalidate cache policy, it is unecessary to call invalidate of children and parents
            // Useless computings are avoided here, as long as the cache policy cannot be more precise
        }
        
    }
}
