<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:math="http://exslt.org/math"
                extension-element-prefixes="ametys math resolver">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>

    <xsl:param name="header" select="ametys:serviceParameter('header')/text()"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">odf-cart</xsl:variable>
    <xsl:variable name="common-service-name">service-odf-cart</xsl:variable> 

    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>        
        </xsl:call-template>
    </xsl:template>   
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-js">
        <!-- Default script for cart -->
        <xsl:call-template name="default-cart-head-js"/>
    </xsl:template>
    
    <xsl:template name="default-cart-head-js">
    	<script type="text/javascript" src="{ametys:pluginResourceURL('odf-web', concat('js/cart/Cart.', ametys:lang(), '.js'))}"></script>
        
        <script type="text/javascript">
            
            __totalEcts = 0;
            __totalHours = 0;
            
            __pCount = 0;
            __cCount = 0;
            
            function _onCartEmpty()
            {
                $j('.empty-cart').show();
            }
            
            function _onCartNotEmpty()
            {
                var programWrap = $j('.cart-items-programs');
                var courseWrap = $j('.cart-items-courses');
                
                if (__pCount &gt; 0)
                    programWrap.show();
                    
                if (__cCount &gt; 0)
                    courseWrap.show();
                    
                $j('.cart-actions').show();
            }
            
            function _computeTotalEcts(item)
            {
                if (item.ects &amp;&amp; item.ects &gt; 0)
                {
                    __totalEcts += item.ects;
                }  
            }
            
            function _computeTotalHours(item)
            {
                if (item.nbHours &amp;&amp; item.nbHours &gt; 0)
                {
                    __totalHours += item.nbHours;
                }
            }
            
            function _updateTotals()
            {
                if (__cCount &gt; 0)
                {
                    var totalsWrap = $j('.cart-totals');
                    totalsWrap.find('.cart-total-ects').find('.cart-total-text').html(__totalEcts + "<i18n:text i18n:key="PLUGINS_ODFWEB_CART_TOTAL_ECTS_UNIT" i18n:catalogue="plugin.odf-web"/>");
                    totalsWrap.find('.cart-total-hours').find('.cart-total-text').html(__totalHours + "<i18n:text i18n:key="PLUGINS_ODFWEB_CART_TOTAL_HOURS_UNIT" i18n:catalogue="plugin.odf-web"/>");
                    totalsWrap.show();
                }
            }
            
            function _updateCartItems(items)
            {
                var template = $j("#cart-item-template").html();
                
                var programWrap = $j('.cart-items-programs');
                var courseWrap = $j('.cart-items-courses');
                
                __pCount = 0;
                __cCount = 0;
                
                __totalEcts = 0;
                __totalHours = 0;
                
                $j(items).each(function(index, item) {
                    
                   var html = template.replace(/{{title}}/ig, item.title)
                        .replace(/{{pageTitle}}/ig, item.pageTitle)
                        .replace(/{{pagePath}}/ig, "<xsl:value-of select="ametys:siteUriPrefix()"/>/<xsl:value-of select="ametys:lang()"/>/" + item.pagePath + ".html")
                        .replace(/{{id}}/ig, item.id)
                        .replace(/{{name}}/ig, item.name)
                        .replace(/{{parentProgramTitle}}/ig, item.parentProgramTitle ? item.parentProgramTitle : '')
                        .replace(/{{itemType}}/ig, item.contentTypeId.substring('org.ametys.plugins.odf.Content.'.length))
                        .replace(/{{hasParentProgram}}/ig, item.parentProgramTitle ? 'true' : 'false')
                        .replace(/{{subscriber}}/ig, item.subscriber === true)
                        .replace(/{{view}}/ig, item.view ? item.view : '');
                      
                   if (item.contentTypeId == 'org.ametys.plugins.odf.Content.program' || item.contentTypeId == 'org.ametys.plugins.odf.Content.subProgram')
                   {
                        programWrap.append(html);
                        __pCount++;
                   }
                   else if (item.contentTypeId == 'org.ametys.plugins.odf.Content.course')
                   {
                        courseWrap.append(html);
                        __cCount++;
                        
                        _computeTotalEcts(item);
                        _computeTotalHours(item);
                   }
                });
                
                if (__pCount + __cCount  &gt; 0)
                {
                    _onCartNotEmpty();
                }
                else
                {
                    _onCartEmpty();
                }
                
                _updateTotals();
            }
            
            $j(document).ready(function() {
                ODFCart.getItems('<xsl:value-of select="ametys:lang()"/>', 'cart', _updateCartItems);
            });
            
        </script>
    </xsl:template>
    
    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>    
    </xsl:template>
    
    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-content">
        <noscript><p><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_NO_SCRIPT"/></p></noscript>
        
        <xsl:call-template name="cart-item-template"/>
        
        <xsl:call-template name="cart-empty"/>
        
        <xsl:call-template name="cart-top"/>
        
        <xsl:call-template name="cart-items"/>
        
        <xsl:call-template name="cart-totals"/>
        
        <xsl:call-template name="cart-bottom"/>
        
        <xsl:call-template name="cart-share-dialog"/>
    </xsl:template>
    
    <xsl:template name="cart-empty">
        <div class="empty-cart" id="cart-empty-{$uniqueId}" style="display: none"><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_EMPTY"/></div>
    </xsl:template>
    
    <xsl:template name="cart-items">
        <div class="cart-items">
        
            <div class="cart-items-programs" id="cart-programs-{$uniqueId}" style="display:none">
                <h2><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_PROGRAM"/></h2>
            </div>
            
            <div class="cart-items-courses" id="cart-courses-{$uniqueId}" style="display:none">
                <h2><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_COURSE"/></h2>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="cart-item-template">
        <script id="cart-item-template" type="text/template">
            <div class="cart-item" data-type="{{{{itemType}}}}">
                <div class="cart-item-elmt">
                    <span data-has-parent="{{{{hasParentProgram}}}}" data-parent-title="{{{{parentProgramTitle}}}}" class="cart-item-parent">{{parentProgramTitle}}</span>
                    {{view}}
                </div>
                <div class="cart-item-actions">
                    <xsl:call-template name="cart-item-see"/>
                    <xsl:call-template name="cart-item-remove"/>
                </div>
            </div>
        </script>
    </xsl:template>
    
    <xsl:template name="cart-item-remove">
        <a class="cart-item-remove" type="button" href="javascript:ODFCart.removeItem('{{{{id}}}}')">
            <span class="cart-item-remove-icon"/>
            <i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_REMOVE" i18n:catalogue="plugin.odf-web"/>
        </a>
    </xsl:template>
    
    <xsl:template name="cart-item-see">
        <a class="cart-item-see" type="button" target="_blank" href="{{{{pagePath}}}}">
            <span class="cart-item-see-icon"/>
            <i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_SEE" i18n:catalogue="plugin.odf-web"/>
        </a>
    </xsl:template>
    
    <xsl:template name="cart-top">
        <xsl:call-template name="cart-action-connect"/>
        <xsl:call-template name="cart-actions"/>
    </xsl:template>
    
    <xsl:template name="cart-bottom">
        <xsl:call-template name="cart-actions"/>
    </xsl:template>
    
    <xsl:template name="cart-totals">
        <div class="cart-totals" style="display:none">
            <xsl:call-template name="cart-total-ects"/>
            <xsl:call-template name="cart-total-hours"/>
		</div>
    </xsl:template>
    
    <xsl:template name="cart-total-ects">
        <div class="cart-total-item cart-total-ects">
            <span class="cart-total-label"><i18n:text i18n:key="PLUGINS_ODFWEB_CART_TOTAL_ECTS" i18n:catalogue="plugin.odf-web"/></span>
            <span class="cart-total-text"></span>
        </div>
    </xsl:template>
    
    <xsl:template name="cart-total-hours">
        <div class="cart-total-item cart-total-hours">
            <span class="cart-total-label"><i18n:text i18n:key="PLUGINS_ODFWEB_CART_TOTAL_HOURS" i18n:catalogue="plugin.odf-web"/></span>
            <span class="cart-total-text"></span>
        </div>
    </xsl:template>
    
    <xsl:template name="cart-actions">
        <div class="cart-actions" style="display:none">
            <xsl:call-template name="cart-action-download"/>
            <xsl:call-template name="cart-action-share"/>
            <xsl:call-template name="cart-action-clear"/>
        </div>
    </xsl:template>
    
    <xsl:template name="cart-action-clear">
        <button class="cart-action-clear" type="button" onclick="ODFCart.removeAll()">
            <i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_REMOVE_ALL" i18n:catalogue="plugin.odf-web"/>
        </button>
    </xsl:template>
    
    <xsl:template name="cart-action-download">
        <button class="cart-action-download" type="button" onclick="ODFCart.download('{ametys:site()}')">
            <i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_DOWNLOAD" i18n:catalogue="plugin.odf-web"/>
        </button>
    </xsl:template>
    
    <xsl:template name="cart-action-share">
        <xsl:if test="ametys:user()">
            <button class="cart-action-share" type="button" onclick="ODFCart.share('{ametys:site()}', 'odfcart-share-dialog')">
                <i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_SHARE" i18n:catalogue="plugin.odf-web"/>
            </button>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="cart-action-connect">
        <xsl:if test="not(ametys:user())">
            <div class="cart-action-connect">
                <i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_SAVE_INFO"/>
                <xsl:text> </xsl:text>
                
                <xsl:variable name="pagePath" select="concat(ametys:absoluteSiteUriPrefix(), '/_authenticate?requestedURL=', '/', ametys:lang(), '/', ametys:pagePath(), '.html')" />
                <a class="cart-save" href="{$pagePath}">
                    <i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_SAVE_LINK_TITLE"/>
                </a>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="cart-share-dialog">
        <div id="odfcart-share-dialog" style="display: none" title="plugin.odf-web:PLUGINS_ODFWEB_SERVICE_CART_SHARE_DIALOG_TITLE" i18n:attr="title">
            <form id="odfcart-share-form"> 
                <p><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_SHARE_DIALOG_HINT" i18n:catalogue="plugin.odf-web"/></p>
                <div class="field">
                    <label for="odfcart-share-email-input">
                        <i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_SHARE_FIELD_EMAIL" i18n:catalogue="plugin.odf-web"/>
                        <xsl:call-template name="cart-share-dialog-mandatorymarker"/>
                    </label>
                    <input name="email" id="odfcart-share-email-input" type="text"/>
                    <br/><span class="hint"><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_SHARE_FIELD_EMAIL_HINT" i18n:catalogue="plugin.odf-web"/></span>
                </div>
                <div class="field">
                    <label for="odfcart-share-message-input"><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_SHARE_FIELD_MESSAGE" i18n:catalogue="plugin.odf-web"/></label>
                    <textarea name="message" id="odfcart-share-message-input" height="160"></textarea>
                </div>
            </form>
        </div>
    </xsl:template>
    
    <xsl:template name="cart-share-dialog-mandatorymarker">
        <span class="mandatory"> *</span>
    </xsl:template> 
    
    
</xsl:stylesheet>
