<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:math="java.lang.Math"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:url-encode="java.net.URLEncoder"
                extension-element-prefixes="math ametys resolver url-encode">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>
        
    <xsl:variable name="search-page" select="ametys:serviceParameter('page-with-search')"/>
    <xsl:variable name="facets" select="ametys:serviceParameter('facets') = 'true'"/>
    <xsl:variable name="header" select="ametys:serviceParameter('header')/text()"/>

    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:variable name="max-value-count" select="5"/>
    
    <xsl:variable name="search-css-class"><xsl:call-template name="search-css-class"/></xsl:variable>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">odf search search-criteria search-odf <xsl:value-of select="$search-css-class"/></xsl:variable>
    <xsl:variable name="is-empty" select="not(/search)"/>
    <xsl:variable name="common-service-name">service-search-odf</xsl:variable>
    
    <xsl:template name="search-css-class">search-odf-programs</xsl:template>
    
    <xsl:variable name="search-url">
        <xsl:if test="$search-page != ''">
            <xsl:value-of select="resolver:resolve('page', $search-page)"/>
        </xsl:if>
    </xsl:variable>
    <xsl:variable name="params">
        <xsl:for-each select="/search/form/values/*[normalize-space(.) != '']">
            <xsl:if test="position() &gt; 1">&amp;</xsl:if>
            <xsl:value-of select="name()"/>=<xsl:value-of select="."/>
        </xsl:for-each>
    </xsl:variable>
    <xsl:variable name="zone-item-id">
        <xsl:value-of select="/search/zone-item/@id"/>
    </xsl:variable>
    
    <!-- +
         | HEAD
         + -->
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:if test="$facets">
            <xsl:call-template name="facets-js"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="facets-js">
        <script src="{$uri-prefix}/plugins/odf-web/resources/js/search/facet-links.{$lang}.js" type="text/javascript"/>
        <script type="text/javascript">
            $j(function() {
                $j('#search-links-<xsl:value-of select="$uniqueId"/> .facet').each(function(){
                    hideExtraFacets($j(this), <xsl:value-of select="$max-value-count"/>);
                });
            });
        </script>
    </xsl:template>
    
    <!-- +
         | BODY
         + -->    
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>    
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="form-criteria"/>
    </xsl:template>
    
    <xsl:template name="form-criteria">
        <xsl:if test="$rendering-context = 'back'">
            <script type="text/javascript">
                function submitBO(pageId, title, href) 
                {
                    var Ext = window.parent.Ext;
                    Ext.MessageBox.show({
                           title:"<i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_BO_TITLE"/>",
                           msg: "<i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_BO_MSG"/> &lt;a href='" + href.replace(/'/g, "&amp;apos;") + "'&gt;" + title + "&lt;/a&gt;.",
                           buttons: Ext.MessageBox.OK,
                           icon: Ext.MessageBox.INFO
                        });
                }
            </script>
        </xsl:if>
        
        <div id="search-links-{$uniqueId}">
            <xsl:choose>
                <xsl:when test="$facets">
                    <xsl:call-template name="form-search-facets"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="form-search"/>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <!-- +
         | Template for search form
         + -->
    <xsl:template name="form-search">
        <xsl:for-each select="/search/form/facets/facet[item]">
            <xsl:call-template name="form-search-element">
                <xsl:with-param name="name" select="@name"/>
                <xsl:with-param name="label" select="label"/>
                <xsl:with-param name="labelAllKey" select="'plugin.odf-web:PLUGINS_ODFWEB_SERVICE_SEARCH_INPUT_ALL'"/>
            </xsl:call-template>
        </xsl:for-each>
        
        <div style="clear:both"/>
    </xsl:template>
    
    <!-- +
         | Template for faceted search links.
         + -->
    <xsl:template name="form-search-facets">
        <div class="facets-criteria">
            <xsl:call-template name="form-search"/>
        </div>
    </xsl:template>
    
    <!-- Form search element -->
    <xsl:template name="form-search-element">
		<xsl:param name="name" />
		<xsl:param name="label" />
		<xsl:param name="labelKey" />
	
		<div class="facet facet-{$name}">
	
			<!-- Facet's title -->
			<div class="facet-label">
				<xsl:choose>
                	<xsl:when test="$labelKey != ''">
                    	<xsl:call-template name="i18n-convert"><xsl:with-param name="i18nkey" select="$labelKey"/></xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                    	<xsl:value-of select="$label"/>
					</xsl:otherwise>
				</xsl:choose>
	
				<!-- Reset button if selected -->
				<xsl:if test="/search/form/values/*/metadata[@name = $name and normalize-space(.) != '']">
					<a class="reset">
						<xsl:attribute name="href">
	                         <xsl:value-of select="$search-url" />
	                         <xsl:text>?</xsl:text>
	                         <xsl:call-template name="get-params">
	                             <xsl:with-param name="param" select="$name" />
	                         </xsl:call-template>
	                     </xsl:attribute>
						<span class="left">
							<i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_UNSELECT_CRITERION" />
						</span>
						<span class="iconSprite"></span>
					</a>
				</xsl:if>
			</div>
	
			<!-- Facet's items -->
			<xsl:choose>
				<!-- The criterion is selected. -->
				<xsl:when test="/search/form/values/*/metadata[@name = $name and normalize-space(.) != '']">
					<xsl:call-template name="form-search-element-selected-choice">
						<xsl:with-param name="name" select="$name" />
					</xsl:call-template>
				</xsl:when>
				<!-- The criterion is not already selected. -->
				<xsl:otherwise>
					<xsl:call-template name="form-search-element-list-choice">
						<xsl:with-param name="name" select="$name" />
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</div>
	</xsl:template>
    
    <xsl:template name="form-search-element-selected-choice">
    	<xsl:param name="name"/>
    	
    	<ul class="options facet-{$name}">
    		 <xsl:variable name="value" select="/search/form/values/*/metadata[@name = $name]"/>
             <li class="option facet-{$name} facet-value-{$value} selected">
             	<span class="facet-label-selected">
                	» <xsl:value-of select="/search/form/fields/metadata[@name = $name]/enumeration/item[@value = $value]/label"/>
                </span>
            </li>
    	</ul>
    </xsl:template>
    
    <xsl:template name="form-search-element-list-choice">
    	<xsl:param name="name"/>
    	
    	<ul class="options facet-{$name}">
	    	<xsl:for-each select="/search/form/facets/facet[@name = $name]/item[@count &gt; 0]">
	        	<xsl:sort select="."/>
	            
	            <xsl:variable name="value" select="@value"/>
	            <li class="option facet-{$name} facet-value-{@value} facet-count-{@count}">
	            	<a>
	                	<xsl:attribute name="href">
	                    	<xsl:value-of select="$search-url"/> <xsl:text>?</xsl:text>
	                        <xsl:call-template name="get-params">
	                        	<xsl:with-param name="param" select="../@name"/>
	                            <xsl:with-param name="value" select="$value"/>
	                        </xsl:call-template>
	                    </xsl:attribute>
	                    <xsl:value-of select="."/><xsl:text> </xsl:text><span class="facet-count-value"><xsl:text>(</xsl:text><xsl:value-of select="@count"/><xsl:text>)</xsl:text></span>
	                </a>
	            </li>
	       </xsl:for-each>
		</ul>
    </xsl:template>
    
    <xsl:template name="get-params">
        <xsl:param name="param"/>
        <xsl:param name="value"/>
        
        <xsl:text>submit-form=</xsl:text>
        <xsl:choose>
            <xsl:when test="/search/group-id and normalize-space(/search/group-id) != ''">
                <xsl:value-of select="/search/group-id"/>
            </xsl:when>
            <xsl:otherwise>true</xsl:otherwise>
        </xsl:choose>
        <xsl:if test="$zone-item-id and $search-page = ''">
            <xsl:text>&amp;zone-item-id=</xsl:text>
            <xsl:value-of select="$zone-item-id"/>
        </xsl:if>
        <xsl:if test="/search/catalog">
            <xsl:text>&amp;catalog=</xsl:text>
            <xsl:value-of select="/search/catalog"/>
        </xsl:if>
        <!-- Selected facets -->
        <xsl:for-each select="/search/form/values/*/metadata[normalize-space(.) != '' and @name != $param]">
            <xsl:text>&amp;</xsl:text>
            <xsl:value-of select="concat('metadata-', @name)"/>=<xsl:value-of select="url-encode:encode(.)"/>
        </xsl:for-each>
        <!-- Clicked facets -->
        <xsl:if test="normalize-space($param) != '' and normalize-space($value) != ''">
            <xsl:text>&amp;</xsl:text>
            <xsl:value-of select="concat('metadata-', $param)"/>=<xsl:value-of select="url-encode:encode($value)"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="i18n-convert">
    	<xsl:param name="i18nkey"/>

		<xsl:choose>
			<xsl:when test="contains($i18nkey,':')">
				<i18n:text i18n:catalogue="{substring-before($i18nkey,':')}" i18n:key="{substring-after($i18nkey,':')}"/>
			</xsl:when>
			<xsl:otherwise>
				<i18n:text i18n:key="{$i18nkey}"/>
			</xsl:otherwise>
		</xsl:choose>
    </xsl:template>
</xsl:stylesheet>
