/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.cdmfr;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import org.ametys.odf.cdmfr.ExportCDMfrHelper;
import org.ametys.odf.program.Program;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;

/**
 * Web implementation of CDM-fr export
 */
public class WebExportCDMfrHelper extends ExportCDMfrHelper
{
    private RenderingContextHandler _renderingContextHandler;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _renderingContextHandler = (RenderingContextHandler) smanager.lookup(RenderingContextHandler.ROLE);
    }
    
    @Override
    protected void _prepareRequest(Program program)
    {
        super._prepareRequest(program);
        
        Request request = _getRequest();
        String siteName = request.getParameter("siteName");
        if (siteName != null)
        {
            request.setAttribute("siteName", siteName);
        }
    }
    
    @Override
    protected void _doExport(ContentHandler contentHandler, Program program) throws SAXException
    {
        RenderingContext currentContext = null; 
        try
        {
            // Switch to FRONT rendering context
            currentContext = _renderingContextHandler.getRenderingContext();
            _renderingContextHandler.setRenderingContext(RenderingContext.FRONT);

            super._doExport(contentHandler, program);
        }
        finally
        {
            _renderingContextHandler.setRenderingContext(currentContext);
        }
    }
}
