/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.service.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.cms.search.SearchResult;
import org.ametys.cms.search.SearchResultsIterable;
import org.ametys.cms.search.advanced.AbstractTreeNode;
import org.ametys.cms.search.advanced.AdvancedQueryBuilder;
import org.ametys.cms.search.content.ContentSearcherFactory;
import org.ametys.cms.search.query.Query;
import org.ametys.plugins.odfweb.service.search.ODFSearchHelper;
import org.ametys.plugins.odfweb.service.search.ProgramReturnable;
import org.ametys.runtime.util.Labelable;
import org.ametys.web.frontoffice.search.instance.SearchServiceInstance;
import org.ametys.web.frontoffice.search.instance.model.RightCheckingMode;
import org.ametys.web.frontoffice.search.instance.model.SearchServiceCriterion;
import org.ametys.web.frontoffice.search.metamodel.AdditionalParameterValueMap;
import org.ametys.web.frontoffice.search.metamodel.Returnable;
import org.ametys.web.frontoffice.search.metamodel.SearchServiceCriterionDefinition;
import org.ametys.web.frontoffice.search.metamodel.SearchServiceFacetDefinition;
import org.ametys.web.frontoffice.search.metamodel.Searchable;
import org.ametys.web.frontoffice.search.requesttime.AbstractSearchComponent;
import org.ametys.web.frontoffice.search.requesttime.SearchComponentArguments;
import org.ametys.web.frontoffice.search.requesttime.impl.SearchComponentHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Request;

public class MatchingSubprogramSearchComponent
extends AbstractSearchComponent
implements Serviceable {
    private static final String __MATCHING_SUBPROGRAM_IDS_ATTR_NAME = MatchingSubprogramSearchComponent.class.getName() + "$matchingSubProgramIds";
    protected ContentSearcherFactory _contentSearcherfactory;
    protected AdvancedQueryBuilder _advancedQueryBuilder;
    protected SearchComponentHelper _searchComponentHelper;
    protected ODFSearchHelper _odfSearchHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._contentSearcherfactory = (ContentSearcherFactory)manager.lookup(ContentSearcherFactory.ROLE);
        this._advancedQueryBuilder = (AdvancedQueryBuilder)manager.lookup(AdvancedQueryBuilder.ROLE);
        this._searchComponentHelper = (SearchComponentHelper)manager.lookup(SearchComponentHelper.ROLE);
        this._odfSearchHelper = (ODFSearchHelper)manager.lookup(ODFSearchHelper.ROLE);
    }

    public int getPriority() {
        return -9000;
    }

    public boolean supports(SearchComponentArguments args) {
        SearchServiceInstance serviceInstance = args.serviceInstance();
        return args.launchSearch() && args.serviceInstance().getCriterionTree().isPresent() && this._containsProgramReturnable(serviceInstance) && this._needSubprogramDiscrimination(serviceInstance);
    }

    private boolean _containsProgramReturnable(SearchServiceInstance serviceInstance) {
        return serviceInstance.getReturnables().stream().map(Returnable::getId).anyMatch(ProgramReturnable.ROLE::equals);
    }

    private boolean _needSubprogramDiscrimination(SearchServiceInstance serviceInstance) {
        AdditionalParameterValueMap additionalParameterValues = serviceInstance.getAdditionalParameterValues();
        ProgramReturnable.DisplaySubprogramMode mode = ProgramReturnable.getDisplaySubprogramMode(additionalParameterValues);
        return mode == ProgramReturnable.DisplaySubprogramMode.ALL_WITH_HIGHLIGHT || mode == ProgramReturnable.DisplaySubprogramMode.MATCHING_SEARCH_ONLY;
    }

    public void execute(SearchComponentArguments args) throws Exception {
        SearchServiceInstance serviceInstance = args.serviceInstance();
        List<String> matchingSubProgramIds = this.retrieveSubProgramsMatchingSearch(serviceInstance, args.userInputs().criteria(), args.serviceInstance().getFacets(), args.userInputs().facets(), args.currentLang());
        MatchingSubprogramSearchComponent._storeInReqMatchingSubProgramIds(args.request(), matchingSubProgramIds);
    }

    protected List<String> retrieveSubProgramsMatchingSearch(SearchServiceInstance serviceInstance, Map<String, Object> userCriteria, Collection<SearchServiceFacetDefinition> serviceFacets, Map<String, List<String>> userFacets, String lang) throws Exception {
        AbstractTreeNode criterionTree = (AbstractTreeNode)serviceInstance.getCriterionTree().get();
        List returnables = serviceInstance.getReturnables();
        Collection searchables = serviceInstance.getSearchables();
        AdditionalParameterValueMap additionalParameters = serviceInstance.getAdditionalParameterValues();
        HashMap<String, Object> contextualParameters = new HashMap<String, Object>();
        Query criterionTreeQuery = this.buildQuery(criterionTree, userCriteria, returnables, searchables, additionalParameters, lang, contextualParameters);
        List facets = serviceFacets.stream().filter(this::_mustKeepFacet).map(Labelable::getName).map(id -> this._odfSearchHelper.getPathFromSearchFieldId((String)id)).collect(Collectors.toList());
        Map<String, List> computedUserFacets = userFacets.entrySet().stream().collect(Collectors.toMap(e -> this._odfSearchHelper.getPathFromSearchFieldId((String)e.getKey()), Map.Entry::getValue));
        RightCheckingMode rightCheckingMode = serviceInstance.getRightCheckingMode();
        SearchResultsIterable results = this._contentSearcherfactory.create(new String[]{"org.ametys.plugins.odf.Content.subProgram"}).withLimits(0, Integer.MAX_VALUE).setCheckRights(switch (rightCheckingMode) {
            case RightCheckingMode.EXACT, RightCheckingMode.FAST -> true;
            case RightCheckingMode.NONE -> false;
            default -> throw new IllegalStateException("Unhandled right checking mode: " + String.valueOf(rightCheckingMode));
        }).withFacets(facets).searchWithFacets(criterionTreeQuery, computedUserFacets).getResults();
        ArrayList<String> contentIds = new ArrayList<String>();
        for (SearchResult content : results) {
            String id2 = ((Content)content.getObject()).getId();
            contentIds.add(id2);
        }
        return contentIds;
    }

    protected Query buildQuery(AbstractTreeNode<SearchServiceCriterion<?>> criterionTree, Map<String, Object> userCriteria, Collection<Returnable> returnables, Collection<Searchable> searchables, AdditionalParameterValueMap additionalParameters, String currentLang, Map<String, Object> contextualParameters) {
        NoSubprogramSearchAdditionalParameterValueMap modifiedAdditionalParameters = new NoSubprogramSearchAdditionalParameterValueMap(additionalParameters);
        Function<SearchServiceCriterion, Query> queryMapper = crit -> this.singleCriterionToQuery((SearchServiceCriterion<?>)crit, userCriteria, returnables, searchables, modifiedAdditionalParameters, currentLang, contextualParameters);
        return this._advancedQueryBuilder.build(criterionTree, queryMapper);
    }

    protected Query singleCriterionToQuery(SearchServiceCriterion<?> criterion, Map<String, Object> userCriteria, Collection<Returnable> returnables, Collection<Searchable> searchables, AdditionalParameterValueMap additionalParameters, String currentLang, Map<String, Object> contextualParameters) {
        Predicate<SearchServiceCriterion> subProgramFilterCriterionPredicate = crit -> this._mustKeepCriterion((SearchServiceCriterion)crit);
        return this._searchComponentHelper.singleCriterionToQuery(criterion, userCriteria, returnables, searchables, additionalParameters, currentLang, subProgramFilterCriterionPredicate, contextualParameters);
    }

    private boolean _mustKeepCriterion(SearchServiceCriterion criterion) {
        SearchServiceCriterionDefinition criterionDefinition = criterion.getCriterionDefinition();
        return this._odfSearchHelper.isCriterionOnBothProgramAndSubProgram(criterionDefinition);
    }

    private boolean _mustKeepFacet(SearchServiceFacetDefinition facet) {
        return this._odfSearchHelper.isFacetOnBothProgramAndSubProgram(facet);
    }

    private static void _storeInReqMatchingSubProgramIds(Request request, List<String> subPrograms) {
        request.setAttribute(__MATCHING_SUBPROGRAM_IDS_ATTR_NAME, subPrograms);
    }

    static List<String> _getMatchingSubProgramIds(Request request) {
        List ids = (List)request.getAttribute(__MATCHING_SUBPROGRAM_IDS_ATTR_NAME);
        return ids == null ? Collections.emptyList() : ids;
    }

    private static class NoSubprogramSearchAdditionalParameterValueMap
    extends AdditionalParameterValueMap {
        private AdditionalParameterValueMap _ref;

        NoSubprogramSearchAdditionalParameterValueMap(AdditionalParameterValueMap ref) {
            super(Collections.emptyMap(), Collections.emptySet());
            this._ref = ref;
        }

        public <T> T getValue(String parameterId) throws ClassCastException {
            return (T)("searchSubprogram".equals(parameterId) ? Boolean.FALSE : this._ref.getValue(parameterId));
        }
    }
}

