<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:math="http://exslt.org/math"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:odf="org.ametys.odf.OdfXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                extension-element-prefixes="resolver exslt">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>    

    <xsl:param name="header" select="ametys:serviceParameter('header')/text()"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">odf-programs-schema</xsl:variable>
    <xsl:variable name="is-empty" select="false()"/>    
    <xsl:variable name="common-service-name">service-odf-programs-schema</xsl:variable> 
    
    <xsl:variable name="suffixeUniqueId" select="substring-after(math:random(), '.')"/>
    <xsl:variable name="uniqueId" select="concat('odf-schema_', $suffixeUniqueId)"/>
    <xsl:variable name="submitFormId" select="''"/>
    
    <xsl:variable name="licence" select="odf:getEntryId('odf-enumeration.Degree', 'XA')"/><!-- Licence -->
    <xsl:variable name="master" select="odf:getEntryId('odf-enumeration.Degree', 'XB')"/><!-- Master -->
    <xsl:variable name="doctorat" select="odf:getEntryId('odf-enumeration.Degree', 'YA')"/><!-- Doctorat -->
    <xsl:variable name="licencepro" select="odf:getEntryId('odf-enumeration.Degree', 'DP')"/><!-- Licence professionnelle -->
    <xsl:variable name="deust" select="odf:getEntryId('odf-enumeration.Degree', 'CD')"/><!-- DEUST -->
    <xsl:variable name="dut" select="odf:getEntryId('odf-enumeration.Degree', 'CB')"/><!-- DUT -->
    <xsl:variable name="di" select="odf:getEntryId('odf-enumeration.Degree', 'FI')"/><!-- Diplôme d'ingenieur -->
    <xsl:variable name="cm" select="odf:getEntryId('odf-enumeration.Degree', 'AC')"/><!-- Capacité en droit -->
    
    
    <!-- +
         | HEAD
         + -->

    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>        
        </xsl:call-template>
    </xsl:template>   
    
   <!-- +
   		| BODY
   		+ -->
   <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>    
    </xsl:template>
    
   	<!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-content">    
    	<xsl:call-template name="odf-schema"/>
    </xsl:template>  
    
    
    <xsl:template name="odf-schema">
    	<div class="odf-schema-map">
    		<xsl:call-template name="general-studies"/>
    	</div>
    </xsl:template>
    
    <xsl:template name="general-studies">
            <xsl:if test="$rendering-context = 'back'">
                <script type="text/javascript">
                    function alertBack_<xsl:value-of select="$suffixeUniqueId" />() 
                    {
                        var Ext = window.parent.Ext;
                        Ext.MessageBox.alert(
                            "<i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_SCHEMA_BO_UNAVAILABLE_TITLE"/>",
                            "<i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_SCHEMA_BO_UNAVAILABLE_DESC"/>"
                        );
                    }
                </script>
            </xsl:if>
        
    		<img src="{ametys:pluginResourceURL('odf-web', 'img/services/schema/etu-generales.png')}" width="306" height="442" id="etudesgenerales" usemap="#m_etugenerales" alt="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_GENERAL_STUDIES" i18n:attr="alt"/>
			<map name="m_etugenerales" id="m_etugenerales">
				<area shape="poly" coords="202,257,261,257,261,300,299,300,299,382,152,382,152,300,202,300,202,257" title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_LICENCE" alt="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_LICENCE" i18n:attr="title alt">
                    <xsl:call-template name="get-href"><xsl:with-param name="qs" select="concat('degree=', $licence)" /></xsl:call-template>
                </area>
				<area shape="rect" coords="152,42,261,168" title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DOCTORAT" alt="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DOCTORAT" i18n:attr="title alt">
                    <xsl:call-template name="get-href"><xsl:with-param name="qs" select="concat('degree=', $doctorat)" /></xsl:call-template>
                </area>
				<area shape="rect" coords="152,171,261,254" title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_MASTER" alt="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_MASTER" i18n:attr="title alt">
                    <xsl:call-template name="get-href"><xsl:with-param name="qs" select="concat('degree=', $master)" /></xsl:call-template>
                </area>
				<area shape="rect" coords="265,171,299,296" title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DI" alt="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DI" i18n:attr="title alt">
                    <xsl:call-template name="get-href"><xsl:with-param name="qs" select="concat('degree=', $di)" /></xsl:call-template>
                </area>
				<area shape="rect" coords="52,257,199,296" title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_LICENCEP" alt="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_LICENCEP" i18n:attr="title alt">
                    <xsl:call-template name="get-href"><xsl:with-param name="qs" select="concat('degree=', $licencepro)" /></xsl:call-template>
                </area>
				<area shape="rect" coords="102,300,149,382" title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DEUST" alt="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DEUST" i18n:attr="title alt">
                    <xsl:call-template name="get-href"><xsl:with-param name="qs" select="concat('degree=', $deust)" /></xsl:call-template>
                </area>
				<area shape="rect" coords="52,300,99,382" title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DUT" alt="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_DUT" i18n:attr="title alt">
                    <xsl:call-template name="get-href"><xsl:with-param name="qs" select="concat('degree=', $dut)" /></xsl:call-template>
                </area>
				<area shape="rect" coords="52,389,199,428" title="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_CM" alt="PLUGINS_ODFWEB_SERVICE_PROGRAMS_SCHEMA_CM" i18n:attr="title alt">
                    <xsl:call-template name="get-href"><xsl:with-param name="qs" select="concat('degree=', $cm)" /></xsl:call-template>
                </area>
			</map>
    </xsl:template>
    
    <xsl:template name="get-href">
        <xsl:param name="qs" select="''" />
        <xsl:attribute name="href">
            <xsl:choose>
                <xsl:when test="$rendering-context = 'back'">
                    <xsl:text>javascript:alertBack_</xsl:text><xsl:value-of select="$suffixeUniqueId" /><xsl:text>();</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat(resolver:resolve('page', ametys:serviceParameter('search-page'), false), '?', $qs, '&amp;submit-form=', $submitFormId)" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
    </xsl:template>
    
</xsl:stylesheet>