<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:xalan="http://xml.apache.org/xalan"
				xmlns:math="java.lang.Math"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="math ametys resolver">
	
    <xsl:variable name="search-page" select="ametys:serviceParameter('page-with-search')"/>
    <xsl:variable name="header" select="ametys:serviceParameter('header')/text()"/>
    <xsl:variable name="rendering-context" select="ametys:renderingContext()"/>

	<xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:variable name="search-odf-type"><xsl:call-template name="search-odf-type"/></xsl:variable>
    <xsl:template name="search-odf-type">program</xsl:template>
    	
	<xsl:template match="/search">
		<html>
		
			<head>
				<link href="{ametys:pluginResourceURL('odf-web', 'css/services/search.css')}" type="text/css" rel="stylesheet" />
				
                <xsl:call-template name="script-autocompletion"/>
                
				<xsl:call-template name="extra-css"/>
				
				<xsl:call-template name="extra-scripts"/>
			</head>
		
			<body id="default">
				
				<div id="service-odf-search-wrapper">
					
					<xsl:if test="$header != ''">
						<h1><xsl:value-of select="$header"/></h1>
					</xsl:if>
					
					<xsl:call-template name="form"/>
				</div>
			</body>
		</html>
	</xsl:template>	
	
	<xsl:template name="form">
        <xsl:if test="$rendering-context = 'back'">
            <script type="text/javascript">
                function submitBO(pageId, title, href) 
                {
                    var Ext = window.parent.Ext;
                    Ext.MessageBox.show({
                           title:"<i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_BO_TITLE"/>",
                           msg: "<i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_BO_MSG"/> &lt;a href='" + href.replace(/'/g, "&amp;apos;") + "'&gt;" + title + "&lt;/a&gt;.",
                           buttons: Ext.MessageBox.OK,
                           icon: Ext.MessageBox.INFO
                        });
                }
            </script>
        </xsl:if>
		<form method="post" class="search">
            <xsl:variable name="href"><xsl:value-of select="resolver:resolve('page', $search-page)"/></xsl:variable>
            <xsl:choose>
                <xsl:when test="$href = ''">
                    <xsl:attribute name="action"><xsl:value-of select="concat($cms-context, '/', /search/url)"/>#nav</xsl:attribute>
                </xsl:when>
                <xsl:when test="$rendering-context != 'back'">
                    <xsl:attribute name="action"><xsl:value-of select="$href"/>#nav</xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="title"><xsl:value-of select="ametys:pageTitle($search-page)"/></xsl:variable>
                    <xsl:attribute name="action">#</xsl:attribute>
                    <xsl:attribute name="onSubmit">submitBO('<xsl:value-of select="$search-page"/>', '<xsl:value-of select="ametys:escapeJS($title)"/>', '<xsl:value-of select="ametys:escapeJS($href)"/>');return false;</xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:call-template name="form-search"/>
		</form>	
	</xsl:template>
	
	<!-- +
	     | Template for search form
	     + -->
	<xsl:template name="form-search">
		<input type="hidden" name="submit-form">
            <xsl:if test="/search/group-id and normalize-space(/search/group-id) != ''">
                <xsl:attribute name="value"><xsl:value-of select="/search/group-id"/></xsl:attribute>
            </xsl:if>
        </input>
        <xsl:if test="/search/zone-item/@id and $search-page = ''">
            <input type="hidden" name="zone-item-id" value="{/search/zone-item/@id}"/>
        </xsl:if>
        <xsl:if test="/search/catalog">
        	<input type="hidden" name="catalog" value="{/search/catalog}"/>
        </xsl:if>
		
		<!-- Label -->
		<xsl:if test="/search/form/fields/title">
			<div class="field">
				<div class="label"><label for="search-title-{$uniqueId}"><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_INPUT_LABEL"/></label></div>
				<div>
					<input id="search-title-{$uniqueId}" type="text" name="title" value="{/search/form/values/title}"/>
					<br/>
				</div>
			</div>
		</xsl:if>
		
		<!-- Keywords -->
		<xsl:if test="/search/form/fields/textfield">
			<div class="field">
				<div class="label"><label for="search-textfield-{$uniqueId}"><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_INPUT_KEYWORDS"/></label></div>
				<div>
					<input id="search-textfield-{$uniqueId}" type="text" name="textfield" value="{/search/form/values/textfield}"/>
					<br/>
					<xsl:if test="/search/illegal-textfield">
						<span class="error"><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_INVALID_TEXTFIELD"/></span>
					</xsl:if>
				</div>
			</div>
		</xsl:if>

        <xsl:if test="/search/form/fields/all-words">
            <div class="field">
                <div class="label"><label for="search-all-words-{$uniqueId}"><i18n:text i18n:key="FRONT_MODULE_SEARCH_ALL_WORDS" i18n:catalogue="plugin.web"/></label></div>
                <div class="input">
                    <input id="search-all-words-{$uniqueId}" type="text" name="all-words" value="{/search/form/values/all-words}" class="text"/>
                </div>
	            <div class="field-end"></div>
            </div>
        </xsl:if>    
    
        <xsl:if test="/search/form/fields/exact-wording">
            <div class="field">
                <div class="label"><label for="search-exact-wording-{$uniqueId}"><i18n:text i18n:key="FRONT_MODULE_SEARCH_EXACT_PHRASE" i18n:catalogue="plugin.web"/></label></div>
                <div class="input">
                    <input id="search-exact-wording-{$uniqueId}" type="text" name="exact-wording" value="{/search/form/values/exact-wording}" class="text"/>
                </div>
	            <div class="field-end"></div>
            </div>
        </xsl:if> 

        <xsl:if test="/search/form/fields/no-words">
            <div class="field">
                <div class="label"><label for="search-no-words-{$uniqueId}"><i18n:text i18n:key="FRONT_MODULE_SEARCH_ANY_WORDS" i18n:catalogue="plugin.web"/></label></div>
                <div class="input">
                    <input id="search-no-words-{$uniqueId}" type="text" name="no-words" value="{/search/form/values/no-words}" class="text"/>
                </div>
	            <div class="field-end"></div>
            </div>
        </xsl:if>
			
		<!-- Domains -->
		<xsl:if test="/search/form/fields/domains/domain">
			<div class="field">
				<div>
					<select name="domain" id="domain-input">
						<option value=""><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_INPUT_DOMAINS_ALL_OPTIONS"/></option>
						<xsl:for-each select="/search/form/fields/domains/domain">
							<xsl:sort select="."/>
							<xsl:variable name="value" select="@value"/>
							<option value="{$value}">
								<xsl:if test="/search/form/values/domain[$value = .]">
									<xsl:attribute name="selected">selected</xsl:attribute>
								</xsl:if>
								<xsl:value-of select="."/>
							</option>
						</xsl:for-each>
					</select>
					<br/>
				</div>
			</div>
		</xsl:if>
		
		<!-- Discipline SISE -->
		<xsl:if test="/search/form/fields/sisesCodes/siseCode">
			<div class="field">
				<div>
					<select name="siseCode" id="siseCode-input">
						<option value=""><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_INPUT_SISECODE_ALL_OPTIONS"/></option>
						<xsl:for-each select="/search/form/fields/siseCodes/siseCode">
							<xsl:sort select="."/>
							<xsl:variable name="value" select="@value"/>
							<option value="{$value}">
								<xsl:if test="/search/form/values/siseCode[$value = .]">
									<xsl:attribute name="selected">selected</xsl:attribute>
								</xsl:if>
								<xsl:value-of select="."/>
							</option>
						</xsl:for-each>
					</select>
					<br/>
				</div>
			</div>
		</xsl:if>
		
		<!-- Secteur DGESIP -->
		<xsl:if test="/search/form/fields/dgesipCodes/dgesipCode">
			<div class="field">
				<div>
					<select name="dgesipCode" id="dgesipCode-input">
						<option value=""><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_INPUT_DGESIP_ALL_OPTIONS"/></option>
						<xsl:for-each select="/search/form/fields/dgesipCodes/dgesipCode">
							<xsl:sort select="."/>
							<xsl:variable name="value" select="@value"/>
							<option value="{$value}">
								<xsl:if test="/search/form/values/dgesipCode[$value = .]">
									<xsl:attribute name="selected">selected</xsl:attribute>
								</xsl:if>
								<xsl:value-of select="."/>
							</option>
						</xsl:for-each>
					</select>
					<br/>
				</div>
			</div>
		</xsl:if>
		
		<!-- Type -->
		<xsl:if test="/search/form/fields/types/type">
			<div class="field">
				<div>
					<select name="type" id="type-input">
						<option value=""><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_INPUT_TYPES_ALL_OPTIONS"/></option>
						<xsl:for-each select="/search/form/fields/types/type">
							<xsl:sort select="."/>
							<xsl:variable name="value" select="@value"/>
							<option value="{$value}">
								<xsl:if test="/search/form/values/type[$value = .]">
									<xsl:attribute name="selected">selected</xsl:attribute>
								</xsl:if>
								<xsl:value-of select="."/>
							</option>
						</xsl:for-each>
					</select>
					<br/>
				</div>
			</div>
		</xsl:if>
			
		<!-- Degrees -->
		<xsl:if test="/search/form/fields/degrees/degree">
			<div class="field">
				<div>
					<select name="degree" id="degree-input">
						<option value=""><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_INPUT_DEGREES_ALL_OPTIONS"/></option>
						<xsl:for-each select="/search/form/fields/degrees/degree">
							<xsl:sort select="."/>
							<xsl:variable name="value" select="@value"/>
							<option value="{$value}">
								<xsl:if test="/search/form/values/degree[$value = .]">
									<xsl:attribute name="selected">selected</xsl:attribute>
								</xsl:if>
								<xsl:value-of select="."/>
							</option>
						</xsl:for-each>
					</select>
					<br/>
				</div>
			</div>
		</xsl:if>
			
		<!-- Composantes -->
		<xsl:if test="/search/form/fields/orgunits/orgunit">
			<div class="field">
				<div>
					<select name="orgunit" id="orgunit-input">
						<option value=""><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_INPUT_ORGUNITS_ALL_OPTIONS"/></option>
						<xsl:for-each select="/search/form/fields/orgunits/orgunit">
							<xsl:sort select="."/>
							<xsl:variable name="value" select="@value"/>
							<option value="{$value}">
								<xsl:if test="/search/form/values/orgunit[$value = .]">
									<xsl:attribute name="selected">selected</xsl:attribute>
								</xsl:if>
								<xsl:value-of select="."/>
							</option>
						</xsl:for-each>
					</select>
					<br/>
				</div>
			</div>
		</xsl:if>
			
		<!-- Levels -->
		<xsl:if test="/search/form/fields/levels/level">
			<div class="field">
				<div>
					<select name="level" id="level-input">
						<option value=""><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_INPUT_LEVELS_ALL_OPTIONS"/></option>
						<xsl:for-each select="/search/form/fields/levels/level">
							<xsl:sort select="."/>
							<xsl:variable name="value" select="@value"/>
							<option value="{$value}">
								<xsl:if test="/search/form/values/level[$value = .]">
									<xsl:attribute name="selected">selected</xsl:attribute>
								</xsl:if>
								<xsl:value-of select="."/>
							</option>
						</xsl:for-each>
					</select>
					<br/>
				</div>
			</div>
		</xsl:if>
		
		<!-- Places -->
		<xsl:if test="/search/form/fields/places/place">
			<div class="field">
				<div>
					<select name="place" id="place-input">
						<option value=""><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_INPUT_PLACES_ALL_OPTIONS"/></option>
						<xsl:for-each select="/search/form/fields/places/place">
							<xsl:sort select="@name"/>
							<xsl:variable name="value" select="@value"/>
							<option value="{$value}">
								<xsl:if test="/search/form/values/place[$value = .]">
									<xsl:attribute name="selected">selected</xsl:attribute>
								</xsl:if>
								<xsl:value-of select="."/>
							</option>
						</xsl:for-each>
					</select>
					<br/>
				</div>
			</div>
		</xsl:if>
        
        <!-- Distance learning -->
        <xsl:if test="/search/form/fields/distanceLearning">
            <div class="field">
                <div>
                    <div>
                        <select name="distanceLearning" id="distanceLearning-input-{$uniqueId}">
                            <option value=""><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_INPUT_DISTANCE_ALL_OPTIONS"/></option>
                            <xsl:for-each select="/search/form/fields/distanceLearning/modality">
                                <xsl:variable name="value" select="@value"/>
                                <option value="{$value}">
                                    <xsl:if test="/search/form/values/distanceLearning[$value = .]">
                                        <xsl:attribute name="selected">selected</xsl:attribute>
                                    </xsl:if>
                                    <xsl:value-of select="."/>
                                </option>
                            </xsl:for-each>
                        </select>
                        <br/>
                    </div>
                </div>
            </div>
        </xsl:if>
        
        <!-- Form of teaching organization -->
        <xsl:if test="/search/form/fields/formofteachingOrg">
            <div class="field">
                <div>
                    <div>
                        <select name="formofteachingOrg" id="formofteachingOrg-input-{$uniqueId}">
                            <option value=""><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_INPUT_TEACHINGORG_ALL_OPTIONS"/></option>
                            <xsl:for-each select="/search/form/fields/formofteachingOrgs/formofteachingOrg">
                                <xsl:variable name="value" select="@value"/>
                                <option value="{$value}">
                                    <xsl:if test="/search/form/values/formofteachingOrg[$value = .]">
                                        <xsl:attribute name="selected">selected</xsl:attribute>
                                    </xsl:if>
                                    <xsl:value-of select="."/>
                                </option>
                            </xsl:for-each>
                        </select>
                        <br/>
                    </div>
                </div>
            </div>
        </xsl:if>
        
		<div class="button"><button type="submit" class="search"><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_BUTTON_OK"/></button></div>
	</xsl:template>
	
	<xsl:template name="script-reload"></xsl:template>
    
    <xsl:template name="script-autocompletion">
        <script type="text/javascript">
            <xsl:comment>
                $j().ready(function() 
                {
                    function parseXML(data) 
                    {
                        var results = [];
                        var branches = $j(data).find('item');
                        $j(branches).each(function() {
                          var text = $j.trim($j(this).text());
                          results[results.length] = {'data': [text, text], 'result': text, 'value': text};
                        });
                        return results;
                    }
                        
                    var url = "<xsl:value-of select="$contextPath"/>/plugins/odf-web/service/search/auto-completion-<xsl:value-of select="$search-odf-type"/>/<xsl:value-of select="$site"/>/<xsl:value-of select="$lang"/>.xml";
                    $j("#search-textfield-<xsl:value-of select="$uniqueId"/>").autocomplete({
                        source: function( request, response ) {
                                $j.ajax({
                                    url: url + "?q=" + request.term,
                                    dataType: "xml",
                                    success: function( xmlResponse  ) {
                                        response( parseXML (xmlResponse));
                                    }
                                });
                        },
                        minLength: 2,
                        delay: 500
                    });
                                                
                });
            </xsl:comment>
        </script>
    </xsl:template>

	<xsl:template name="extra-scripts"></xsl:template>
	
	<xsl:template name="extra-css"></xsl:template>
			
</xsl:stylesheet>
