<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:xalan="http://xml.apache.org/xalan"
				xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:url-encode="java.net.URLEncoder"
                xmlns:str="http://exslt.org/strings"
                extension-element-prefixes="math str url-encode">
		
	<xsl:import href="plugin:odf-web://pages/services/search/search-criteria/search-criteria.xsl"/>
	
    <xsl:variable name="cms-context" select="ametys:siteUriPrefix()"/>
	<xsl:variable name="search-mode" select="ametys:serviceParameter('search-mode')/text()"/>

	<xsl:template name="form">
		<form action="{$cms-context}/{/search/url}#nav" method="post" class="search">
			<xsl:choose>
				<xsl:when test="$search-mode = 'criteria-only' or $search-mode = 'criteria-and-results' or count(hits/hit) = 0">
					<xsl:call-template name="form-search"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="form-search-hidden"/>
					<div class="back"><a href="{$cms-context}/{url}" title="plugin.odf-web:PLUGINS_ODFWEB_SERVICE_SEARCH_NEW_SEARCH_TITLE" i18n:attr="title"><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_NEW_SEARCH"/></a></div>
				</xsl:otherwise>
			</xsl:choose>
				
			<a name="nav"/>
			
			<xsl:if test="hits/hit">
				<xsl:call-template name="results-sort"/>
			</xsl:if>
		</form>	
		
		<xsl:choose>
			<xsl:when test="hits/hit">
				<xsl:call-template name="hits"/>
				
				<xsl:call-template name="pagination"/>
			</xsl:when>
			
			<xsl:when test="/search/form/values and not(/search/illegal-textfield)">
				<div class="no-result"><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_NO_RESULT"/></div>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<!-- +
		 | Template for results
		 + -->
	<xsl:template name="hits">
		
		<dl class="search-hits">
							
			<xsl:for-each select="/search/hits/hit">
				<dt class="hit">
					<xsl:if test="position() mod 2 = 0"><xsl:attribute name="class">hit even</xsl:attribute></xsl:if>
					<a title="{title}">
                       	<xsl:attribute name="href"><xsl:call-template name="hit-href"/></xsl:attribute>
						<xsl:value-of select="title"/>
					</a>
				</dt>
				<dd class="hit">	
					<xsl:if test="position() mod 2 = 0"><xsl:attribute name="class">hit even</xsl:attribute></xsl:if>
					<xsl:value-of select="excerpt"/>
				</dd>
			</xsl:for-each>
			
		</dl>
	</xsl:template>	
	
	<!-- +
		 | Template for results sort
		 + -->
	<xsl:template name="results-sort">
		<div class="results-sort">
			<ul class="sort">
				<li><span><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_SORT_BY"/></span></li>
				<li>
					<xsl:choose>
						<xsl:when test="/search/sort-by-score">
							<i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_SORT_BY_SCORE"/>
						</xsl:when>
						<xsl:otherwise>
							<input type="submit" name="sort-by-score" value="plugin.odf-web:PLUGINS_ODFWEB_SERVICE_SEARCH_SORT_BY_SCORE" i18n:attr="value"/>
						</xsl:otherwise>
					</xsl:choose>
				</li>
				<li>
					<xsl:choose>
						<xsl:when test="/search/sort-by-title-for-sorting">
							<i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_SORT_BY_TITLE"/>
						</xsl:when>
						<xsl:otherwise>
							<input type="submit" name="sort-by-title-for-sorting" value="plugin.odf-web:PLUGINS_ODFWEB_SERVICE_SEARCH_SORT_BY_TITLE" i18n:attr="value"/>
						</xsl:otherwise>
					</xsl:choose>
				</li>
			</ul>
		</div>
	</xsl:template>
	
	<!-- +
		 | Template for page navigation
		 + -->
	<xsl:template name="pagination">
		<form id="reload" method="post" action="{$cms-context}/{/search/url}#nav" accept-charset="UTF-8">
			<div>
                <input type="hidden" name="submit-form">
                    <xsl:if test="/search/group-id and normalize-space(/search/group-id) != ''">
                        <xsl:attribute name="value"><xsl:value-of select="/search/group-id"/></xsl:attribute>
                    </xsl:if>
                </input>
                <xsl:if test="/search/zone-item/@id">
                    <input type="hidden" name="zone-item-id" value="{/search/zone-item/@id}"/>
                </xsl:if>
				<input type="hidden" name="textfield" value="{/search/form/values/textfield}"/>
		        <xsl:if test="/search/form/fields/all-words">
		            <input type="hidden" name="all-words" value="{/search/form/values/all-words}"/>
		        </xsl:if>
		        <xsl:if test="/search/form/fields/exact-wording">
		            <input type="hidden" name="exact-wording" value="{/search/form/values/exact-wording}"/>
		        </xsl:if>
		        <xsl:if test="/search/form/fields/no-words">
		            <input type="hidden" name="no-words" value="{/search/form/values/no-words}"/>
		        </xsl:if>
				<input type="hidden" name="title" value="{/search/form/values/title}"/>
				<input type="hidden" name="degree" value="{/search/form/values/degree}"/>
				<input type="hidden" name="domain" value="{/search/form/values/domain}"/>
				<input type="hidden" name="siseCode" value="{/search/form/values/siseCode}"/>
				<input type="hidden" name="dgesipCode" value="{/search/form/values/dgesipCode}"/>
				<input type="hidden" name="orgunit" value="{/search/form/values/orgunit}"/>
				<input type="hidden" name="place" value="{/search/form/values/place}"/>
				<input type="hidden" name="level" value="{/search/form/values/level}"/>
				<input type="hidden" name="type" value="{/search/form/values/type}"/>
				<input type="hidden" name="offset" value="{/search/form/values/offset}"/>
				<input type="hidden" name="start" value="{/search/form/values/start}"/>
			</div>
			
			<div class="pagination">
				
				<p class="result">
					<i18n:translate>
						<i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_RESULTS"/>
						<i18n:param><xsl:value-of select="/search/pagination/@start + 1"/></i18n:param>
						<i18n:param><xsl:value-of select="/search/pagination/@end"/></i18n:param>
						<i18n:param><xsl:value-of select="/search/hits/@total"/></i18n:param>
					</i18n:translate>
				</p>			
				
				<ul class="nav">
					
					<xsl:variable name="nbPages"><xsl:value-of select="count(/search/pagination/page)"/></xsl:variable>
					<xsl:variable name="current-page" select="xalan:nodeset(/search/pagination/page[@start = ../@start])"></xsl:variable>
					
					<li><i18n:text i18n:catalogue="plugin.odf-web" i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_NAV_PAGES"/></li>
					
					<xsl:if test="$current-page/@index &gt; 2">
						<!-- First page -->
						<li class="first">
							<input type="submit" name="page-{/search/pagination/page[position() = 1]/@index}" value="&lt;"/>
						</li>
					</xsl:if>
					
					<xsl:if test="$current-page/@index != 1">
						<!-- Precede page -->
						<li class="precede">
							<input type="submit" name="page-{$current-page/preceding-sibling::page[1]/@index}" value="plugin.odf-web:PLUGINS_ODFWEB_SERVICE_SEARCH_NAV_PRECEDE" i18n:attr="value"/>
						</li>
					</xsl:if>
					
					<xsl:for-each select="$current-page/preceding-sibling::page[position() &lt; 4]">
						 <li class="page">
						 	<input type="submit" name="page-{@index}" value="{@index}"/>
						 </li>
					</xsl:for-each>
					
					 <li class="page"><xsl:value-of select="$current-page/@index"/></li>
					
					<xsl:for-each select="$current-page/following-sibling::page[position() &lt; 4]">
						 <li class="page">
						 	<input type="submit" name="page-{@index}" value="{@index}"></input>
						 </li>
					</xsl:for-each>
								
					<xsl:if test="$current-page/@index != $nbPages">
						<!-- Next page -->
						<li class="next">
							<input type="submit" name="page-{$current-page/following-sibling::page[1]/@index}" value="plugin.odf-web:PLUGINS_ODFWEB_SERVICE_SEARCH_NAV_NEXT"  i18n:attr="value"/>
						</li>
					</xsl:if>
					
					<xsl:if test="$current-page &lt; ($nbPages - 2)">
						<!-- Last page -->
						<li class="last">	
							<input type="submit" name="page-{/search/pagination/page[position() = last()]/@index}" value="&gt;"/>
						</li>
					</xsl:if>
				
				</ul>
			</div>
		
		</form>
	</xsl:template>
	
	<!-- +
	     | Template for search form (mode hidden)
	     + -->
	<xsl:template name="form-search-hidden">
		<input type="hidden" name="submit-form">
            <xsl:if test="/search/group-id and normalize-space(/search/group-id) != ''">
                <xsl:attribute name="value"><xsl:value-of select="/search/group-id"/></xsl:attribute>
            </xsl:if>
        </input>
        <xsl:if test="/search/zone-item/@id">
            <input type="hidden" name="zone-item-id" value="{/search/zone-item/@id}"/>
        </xsl:if>
		<input type="hidden" name="textfield" value="{/search/form/values/textfield}"/>
        <xsl:if test="/search/form/fields/all-words">
            <input type="hidden" name="all-words" value="{/search/form/values/all-words}"/>
        </xsl:if>
        <xsl:if test="/search/form/fields/exact-wording">
            <input type="hidden" name="exact-wording" value="{/search/form/values/exact-wording}"/>
        </xsl:if>
        <xsl:if test="/search/form/fields/no-words">
            <input type="hidden" name="no-words" value="{/search/form/values/no-words}"/>
        </xsl:if>
		<input type="hidden" name="title" value="{/search/form/values/title}"/>
		<input type="hidden" name="degree" value="{/search/form/values/degree}"/>
		<input type="hidden" name="domain" value="{/search/form/values/domain}"/>
		<input type="hidden" name="dgesipCode" value="{/search/form/values/dgesipCode}"/>
		<input type="hidden" name="siseCode" value="{/search/form/values/siseCode}"/>
		<input type="hidden" name="type" value="{/search/form/values/type}"/>
		<input type="hidden" name="orgunit" value="{/search/form/values/orgunit}"/>
		<input type="hidden" name="place" value="{/search/form/values/place}"/>
		<input type="hidden" name="level" value="{/search/form/values/level}"/>
	</xsl:template>

    <xsl:template name="hit-href">
    	<xsl:param name="url" select="uri"/>
    	
		<xsl:value-of select="$cms-context"/><xsl:text>/</xsl:text><xsl:value-of select="$url"/><xsl:text>.html</xsl:text>
		<xsl:if test="/search/form/values/textfield != '' or /search/form/values/all-words != '' or /search/form/values/exact-wording != ''">
			<xsl:choose>
				<xsl:when test="contains(uri, '?')">&amp;</xsl:when>
				<xsl:otherwise>?</xsl:otherwise>
			</xsl:choose>
			<xsl:text>search-keywords=</xsl:text>
			<xsl:if test="/search/form/values/textfield != ''"><xsl:value-of select="url-encode:encode(/search/form/values/textfield)"/></xsl:if>
			<xsl:if test="/search/form/values/all-words != ''">
				<xsl:if test="/search/form/values/textfield != ''">,</xsl:if>
				<xsl:for-each select="str:split(/search/form/values/all-words)">
					<xsl:if test="position() &gt; 1">,</xsl:if>
					<xsl:value-of select="url-encode:encode(.)"/>
				</xsl:for-each>
			</xsl:if>
			<xsl:if test="/search/form/values/exact-wording != ''">
				<xsl:if test="/search/form/values/textfield != '' or /search/form/values/all-words != ''">,</xsl:if>
				<xsl:value-of select="url-encode:encode(/search/form/values/exact-wording)"/>
			</xsl:if>
		</xsl:if>
     </xsl:template>
</xsl:stylesheet>