/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.observation.solr;

import java.util.Map;
import org.ametys.cms.content.indexing.solr.observation.ObserverHelper;
import org.ametys.core.observation.Event;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.web.indexing.observation.AbstractSolrObserver;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public abstract class AbstractSolrOnSiteConfModifiedObserver
extends AbstractSolrObserver
implements Contextualizable {
    private OdfPageHandler _odfPageHandler;
    private Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._odfPageHandler = (OdfPageHandler)((Object)manager.lookup(OdfPageHandler.ROLE));
    }

    public boolean supports(Event event) {
        return event.getId().equals("site.updated");
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        if (ObserverHelper.isNotSuspendedObservationForIndexation()) {
            Request request = ContextHelper.getRequest((Context)this._context);
            request.setAttribute("odfweb.solr.indexing", (Object)true);
            Site site = (Site)event.getArguments().get("site");
            if (site != null) {
                this._updateOdfRootIndex(site);
            }
        }
    }

    private void _updateOdfRootIndex(Site site) throws Exception {
        String siteName = site.getName();
        for (Sitemap sitemap : site.getSitemaps()) {
            for (Page odfRootPage : this._odfPageHandler.getOdfRootPages(siteName, sitemap.getSitemapName())) {
                this._updateIndex(odfRootPage);
            }
        }
    }

    protected abstract void _updateIndex(Page var1) throws Exception;
}

