/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.program;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.cms.data.ContentValue;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.ProgramPart;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.runtime.model.ModelItem;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ProgramListGenerator
extends ServiceableGenerator {
    protected AmetysObjectResolver _ametysResolver;
    protected OdfPageHandler _odfPageHandler;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._ametysResolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._odfPageHandler = (OdfPageHandler)((Object)serviceManager.lookup(OdfPageHandler.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String site = this.parameters.getParameter("site", (String)request.getAttribute("site"));
        String lang = this.parameters.getParameter("lang", (String)request.getAttribute("sitemapLanguage"));
        String catalog = this.parameters.getParameter("catalog", (String)request.getAttribute("catalog"));
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(ZoneItem.class.getName());
        String[] filteredByOrgUnits = (String[])zoneItem.getServiceParameters().getValue("orgunitlist", false, (Object)new String[0]);
        Page rootPage = this._odfPageHandler.getOdfRootPage(site, lang, catalog);
        if (rootPage == null) {
            throw new IllegalArgumentException("There is no ODF root page for catalog '" + catalog + "' and language '" + lang + "'.");
        }
        AmetysObjectIterable<Program> programs = this._odfPageHandler.getProgramsWithRestrictions(rootPage, null, null, null, null);
        this.contentHandler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("root-page-path", rootPage.getPathInSitemap());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"programs", (Attributes)atts);
        HashMap<String, List<String>> metadataFilters = new HashMap<String, List<String>>();
        if (filteredByOrgUnits.length > 0) {
            List<String> filteredByOrgUnitsAsList = Arrays.asList(filteredByOrgUnits);
            metadataFilters.put("orgUnit", filteredByOrgUnitsAsList);
            for (Program program : programs) {
                List orgUnits = program.getOrgUnits();
                boolean found = false;
                for (String ouId : orgUnits) {
                    try {
                        OrgUnit ou = (OrgUnit)this._ametysResolver.resolveById(ouId);
                        if (!this._isEqualOrHasParentInList(ou, filteredByOrgUnitsAsList)) continue;
                        found = true;
                        break;
                    }
                    catch (UnknownAmetysObjectException e) {
                        this.getLogger().error("The OrgUnit with id '" + ouId + "' does not exist anymore. It will be ignored.", (Throwable)e);
                    }
                }
                if (!found) continue;
                this.saxProgram(program, metadataFilters);
            }
        } else {
            for (Program program : programs) {
                this.saxProgram(program, metadataFilters);
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"programs");
        this.contentHandler.endDocument();
    }

    private boolean _isEqualOrHasParentInList(OrgUnit ou, List<String> filteredOrgUnits) {
        if (filteredOrgUnits.contains(ou.getId())) {
            return true;
        }
        for (OrgUnit parentOrgUnit = ou.getParentOrgUnit(); parentOrgUnit != null; parentOrgUnit = parentOrgUnit.getParentOrgUnit()) {
            if (!filteredOrgUnits.contains(parentOrgUnit.getId())) continue;
            return true;
        }
        return false;
    }

    public void saxProgram(Program program, HashMap<String, List<String>> attributeFilters) throws SAXException, IOException {
        Map<String, ModelItem> enumeratedAttributes = this._odfPageHandler.getEnumeratedAttributes("org.ametys.plugins.odf.Content.program", true);
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("id", program.getId());
        atts.addCDATAAttribute("name", program.getName());
        atts.addCDATAAttribute("title", program.getTitle());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"program", (Attributes)atts);
        for (String attributePath : enumeratedAttributes.keySet()) {
            List values = Optional.ofNullable(program.getValue(attributePath)).map(this::_valuesAsList).orElse(Collections.emptyList()).stream().filter(value -> value instanceof String || value instanceof ContentValue).map(value -> value instanceof ContentValue ? ((ContentValue)value).getContentId() : (String)value).collect(Collectors.toList());
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("path", attributePath);
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"metadata", (Attributes)attrs);
            for (String value2 : values) {
                if (!this._filterAttributes(attributePath, value2, attributeFilters)) continue;
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (String)value2);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"metadata");
        }
        for (ProgramPart programPart : program.getProgramPartChildren()) {
            if (!(programPart instanceof SubProgram)) continue;
            this.saxSubProgram((SubProgram)programPart);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"program");
    }

    private List<Object> _valuesAsList(Object values) {
        if (values instanceof Collection) {
            return new ArrayList<Object>((Collection)values);
        }
        if (values instanceof Object[]) {
            return Arrays.asList((Object[])values);
        }
        return Arrays.asList(values);
    }

    private boolean _filterAttributes(String attributePath, String value, HashMap<String, List<String>> attributeFilters) {
        if (attributePath.equals("orgUnit") && attributeFilters.containsKey("orgUnit")) {
            try {
                OrgUnit ou = (OrgUnit)this._ametysResolver.resolveById(value);
                return this._isEqualOrHasParentInList(ou, attributeFilters.get("orgUnit"));
            }
            catch (UnknownAmetysObjectException e) {
                this.getLogger().error("The OrgUnit with id '" + value + "' does not exist anymore. It will be ignored.", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    protected void saxSubProgram(SubProgram subProgram) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("id", subProgram.getId());
        atts.addCDATAAttribute("name", subProgram.getName());
        atts.addCDATAAttribute("title", subProgram.getTitle());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"subprogram", (Attributes)atts);
    }

    protected void saxCriterionValue(String name, String value) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("name", name);
        attrs.addCDATAAttribute("value", value);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"criterion", (Attributes)attrs);
    }
}

