/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.restrictions.rules;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfweb.restrictions.rules.OdfRestrictionRule;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.model.type.ElementType;

public class OdfAttributeRestrictionRule
implements OdfRestrictionRule {
    private final String _attributePath;
    private final String _untypedValue;

    public OdfAttributeRestrictionRule(String attributePath, String untypedValue) {
        this._attributePath = attributePath;
        this._untypedValue = untypedValue;
    }

    @Override
    public Expression getExpression() {
        return new StringExpression(this._attributePath, Expression.Operator.EQ, this._untypedValue);
    }

    @Override
    public boolean contains(Program program) {
        ElementType type = (ElementType)program.getDefinition(this._attributePath).getType();
        Object typedValue = type.castValue((Object)this._untypedValue);
        return Optional.ofNullable(program.getValue(this._attributePath)).map(value -> Arrays.asList(value)).orElse(Collections.EMPTY_LIST).stream().anyMatch(value -> value.equals(typedValue));
    }

    @Override
    public boolean hasOrgunitRestrictions() {
        return false;
    }
}

