/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.service.search;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.plugins.odfweb.service.search.helper.DegreeUniversityHelper;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.web.frontoffice.search.requesttime.AbstractSearchComponent;
import org.ametys.web.frontoffice.search.requesttime.SearchComponentArguments;
import org.ametys.web.frontoffice.search.requesttime.input.SearchUserInputs;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class DegreeUniversitySearchComponent
extends AbstractSearchComponent
implements Serviceable {
    protected DegreeUniversityHelper _degreeUniversityHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._degreeUniversityHelper = (DegreeUniversityHelper)((Object)manager.lookup(DegreeUniversityHelper.ROLE));
    }

    public int getPriority() {
        return Integer.MIN_VALUE;
    }

    public boolean supports(SearchComponentArguments args) {
        return args.launchSearch();
    }

    public void execute(SearchComponentArguments args) throws Exception {
        SearchUserInputs userInputs = args.userInputs();
        HashMap<String, List> facets = new HashMap<String, List>();
        for (Map.Entry entry : userInputs.facets().entrySet()) {
            if (((String)entry.getKey()).equals("ContentReturnable$ProgramSearchable$org.ametys.plugins.odf.Content.program$degree$University")) {
                facets.put(this._getCriterionKey(args), this._updatedFacetsValues((List)entry.getValue()));
                continue;
            }
            facets.put((String)entry.getKey(), (List)entry.getValue());
        }
        userInputs.setFacets(facets);
        args.updateUserInputs(userInputs);
    }

    private String _getCriterionKey(SearchComponentArguments args) {
        String key = "ContentReturnable$ProgramSearchable$org.ametys.plugins.odf.Content.program$degree";
        boolean present = args.serviceInstance().getFacets().stream().anyMatch(f -> f.getName().equals(key));
        return present ? key : "ContentReturnable$ProgramSearchable$org.ametys.plugins.odf.Content.program$degree$University";
    }

    private List<String> _updatedFacetsValues(List<String> facets) {
        return facets.stream().map(this::_getDegreeValues).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<String> _getDegreeValues(String value) {
        if ("_Ametys_Degree_All_University".equals(value)) {
            return this._degreeUniversityHelper.getDegrees(true).stream().map(AmetysObject::getId).collect(Collectors.toList());
        }
        return List.of(value);
    }
}

