/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.repository;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.ametys.odf.tree.OdfClassificationHandler;
import org.ametys.plugins.odfweb.repository.AbstractOdfPageFactory;
import org.ametys.plugins.odfweb.repository.FirstLevelPage;
import org.ametys.plugins.odfweb.repository.SecondLevelPage;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.web.repository.page.Page;
import org.apache.commons.lang3.StringUtils;

public class SecondLevelPageFactory
extends AbstractOdfPageFactory
implements AmetysObjectFactory<SecondLevelPage> {
    public SecondLevelPage createSecondLevelPage(Page root, String level1Key, String name, String title, FirstLevelPage firstLevelPage) {
        return new SecondLevelPage(root, this.getConfiguration(), this, level1Key, name, title, firstLevelPage);
    }

    public SecondLevelPage getAmetysObjectById(String id) throws AmetysRepositoryException {
        String[] levels = this._extractLevels(id);
        String level1Code = levels[0];
        String level2Code = levels[1];
        Page rootPage = this._extractRoot(id);
        return this._findSecondLevelValueEntry(rootPage, level2Code).map(entry -> this._toSecondLevelPage(rootPage, level1Code, (Map.Entry<String, OdfClassificationHandler.LevelValue>)entry)).orElseThrow(() -> new UnknownAmetysObjectException("There's no virtual child page named " + level2Code + " for parent " + String.valueOf(rootPage)));
    }

    private Page _extractRoot(String id) {
        String rootId = StringUtils.substringAfter((String)id, (String)"?rootId=");
        return (Page)this._resolver.resolveById(rootId);
    }

    private String[] _extractLevels(String id) {
        String levelParts = StringUtils.substringBetween((String)id, (String)"://", (String)"?");
        return (String[])Arrays.stream(StringUtils.split((String)levelParts, (char)'/')).map(this._odfPageHandler::decodeLevelValue).toArray(String[]::new);
    }

    private Optional<Map.Entry<String, OdfClassificationHandler.LevelValue>> _findSecondLevelValueEntry(Page rootPage, String levelCode) {
        Map<String, OdfClassificationHandler.LevelValue> secondLevelValues = this._odfPageHandler.getLevel2Values(rootPage);
        return this._findSecondLevelValueEntry(secondLevelValues, levelCode);
    }

    private Optional<Map.Entry<String, OdfClassificationHandler.LevelValue>> _findSecondLevelValueEntry(Map<String, OdfClassificationHandler.LevelValue> secondLevelValues, String levelCode) {
        return secondLevelValues.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(levelCode)).findFirst();
    }

    private SecondLevelPage _toSecondLevelPage(Page rootPage, String level1Code, Map.Entry<String, OdfClassificationHandler.LevelValue> secondLevelValueEntry) {
        String level2Code = secondLevelValueEntry.getKey();
        String title = secondLevelValueEntry.getValue().getValue();
        return this.createSecondLevelPage(rootPage, level1Code, level2Code, title, null);
    }

    public String getScheme() {
        return "odfLevel2";
    }

    public boolean hasAmetysObjectForId(String id) throws AmetysRepositoryException {
        String[] levels = this._extractLevels(id);
        Page root = this._extractRoot(id);
        return this._hasSecondLevelValue(root, levels[1]);
    }

    private boolean _hasSecondLevelValue(Page rootPage, String level2Code) throws AmetysRepositoryException {
        Map<String, OdfClassificationHandler.LevelValue> secondLevelValues = this._odfPageHandler.getLevel2Values(rootPage);
        return secondLevelValues.containsKey(level2Code);
    }
}

