/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.restrictions;

import java.util.Collections;
import java.util.List;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfweb.restrictions.rules.OdfAndRestrictionRule;
import org.ametys.plugins.odfweb.restrictions.rules.OdfRestrictionRule;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.runtime.i18n.I18nizableText;

public class OdfProgramRestriction {
    private final String _id;
    private final I18nizableText _label;
    private final OdfRestrictionRule _rule;

    public OdfProgramRestriction(String id, I18nizableText label, OdfRestrictionRule rule) {
        this._id = id;
        this._label = label;
        this._rule = rule;
        if (this._rule == null) {
            throw new IllegalArgumentException("At least one non-null rule is required.");
        }
    }

    public OdfProgramRestriction(String id, I18nizableText label, List<OdfRestrictionRule> rules) {
        this(id, label, OdfProgramRestriction._extractMainRule(rules));
    }

    private static OdfRestrictionRule _extractMainRule(List<OdfRestrictionRule> rules) {
        rules.removeAll(Collections.singleton(null));
        OdfRestrictionRule rule = null;
        if (rules.size() > 1) {
            rule = new OdfAndRestrictionRule(rules);
        } else if (!rules.isEmpty()) {
            rule = rules.iterator().next();
        } else {
            throw new IllegalArgumentException("At least one non-null rule is required.");
        }
        return rule;
    }

    public String getId() {
        return this._id;
    }

    public I18nizableText getLabel() {
        return this._label;
    }

    public boolean contains(Program program) {
        return this._rule.contains(program);
    }

    public Expression getExpression() {
        return this._rule.getExpression();
    }

    public boolean hasOrgunitRestrictions() {
        return this._rule.hasOrgunitRestrictions();
    }
}

