/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.xslt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.core.util.dom.AmetysNodeList;
import org.ametys.core.util.dom.MapElement;
import org.ametys.core.util.dom.StringElement;
import org.ametys.odf.EducationalPathHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.catalog.Catalog;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.odf.course.Course;
import org.ametys.odf.data.EducationalPath;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.odf.skill.ODFSkillsHelper;
import org.ametys.plugins.odfweb.repository.CoursePage;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.odfweb.repository.OdfPageResolver;
import org.ametys.plugins.odfweb.repository.ProgramPage;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.runtime.config.Config;
import org.ametys.web.WebConstants;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.transformation.xslt.AmetysXSLTHelper;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.w3c.dom.NodeList;

public class OdfXSLTHelper
extends org.ametys.odf.OdfXSLTHelper
implements Contextualizable {
    protected static OdfPageHandler _odfPageHandler;
    protected static ODFSkillsHelper _odfSkillsHelper;
    protected static OdfPageResolver _odfPageResolver;
    protected static CatalogsManager _catalogsManager;
    protected static Context _context;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        _odfPageHandler = (OdfPageHandler)((Object)smanager.lookup(OdfPageHandler.ROLE));
        _odfSkillsHelper = (ODFSkillsHelper)smanager.lookup(ODFSkillsHelper.ROLE);
        _odfPageResolver = (OdfPageResolver)((Object)smanager.lookup(OdfPageResolver.ROLE));
        _catalogsManager = (CatalogsManager)smanager.lookup(CatalogsManager.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        _context = context;
    }

    public static String odfRootPage(String siteName, String language) {
        Page odfRootPage = _odfPageHandler.getOdfRootPage(siteName, language);
        if (odfRootPage != null) {
            return odfRootPage.getId();
        }
        return null;
    }

    public static String odfRootPage(String siteName, String language, String catalog) {
        Page odfRootPage = _odfPageHandler.getOdfRootPage(siteName, language, catalog);
        if (odfRootPage != null) {
            return odfRootPage.getId();
        }
        return null;
    }

    public static String odfPDFUrl(String contentId, String siteName) {
        StringBuilder sb = new StringBuilder();
        Content content = (Content)_ametysObjectResolver.resolveById(contentId);
        if (content instanceof AbstractProgram) {
            sb.append(AmetysXSLTHelper.uriPrefix()).append("/plugins/odf-web/").append(siteName).append("/_content/").append(content.getName()).append(".pdf");
        }
        return sb.toString();
    }

    public static String parentProgramId() {
        String pageId = AmetysXSLTHelper.pageId();
        if (StringUtils.isNotEmpty((String)pageId)) {
            Page page = (Page)_ametysObjectResolver.resolveById(pageId);
            AmetysObject parent = page.getParent();
            while (!(parent instanceof Sitemap)) {
                if (parent instanceof ProgramPage) {
                    return ((ProgramPage)parent).getProgram().getId();
                }
                parent = parent.getParent();
            }
        }
        return null;
    }

    public static double getCurrentEcts() {
        ProgramItem programItem;
        Pair<ProgramItem, List<EducationalPath>> currentEducationalPaths = OdfXSLTHelper._getCurrentEducationalPaths();
        if (currentEducationalPaths != null && (programItem = (ProgramItem)currentEducationalPaths.getLeft()) instanceof Course) {
            Course course = (Course)programItem;
            return course.getEcts((List)currentEducationalPaths.getRight());
        }
        return 0.0;
    }

    public static NodeList getCurrentSkills() {
        ArrayList<StringElement> result = new ArrayList<StringElement>();
        boolean isSkillsEnabled = (Boolean)Config.getInstance().getValue("odf.skills.enabled");
        if (!isSkillsEnabled) {
            return new AmetysNodeList(result);
        }
        Pair<ProgramItem, List<EducationalPath>> currentEducationalPaths = OdfXSLTHelper._getCurrentEducationalPaths();
        if (currentEducationalPaths != null) {
            ProgramItem programItem = (ProgramItem)currentEducationalPaths.getLeft();
            List educationalPath = (List)currentEducationalPaths.getRight();
            if (programItem instanceof Course) {
                Course course = (Course)programItem;
                if (!educationalPath.isEmpty()) {
                    EducationalPath programEducationalPath = (EducationalPath)educationalPath.getFirst();
                    String programId = (String)programEducationalPath.getProgramItemIds().get(0);
                    ContentValue[] skillsValues = course.getAcquiredSkills(programId);
                    HashMap<String, StringElement> createdMacroSkillNode = new HashMap<String, StringElement>();
                    for (ContentValue skillValue : skillsValues) {
                        Optional optionalParentMacroSkill;
                        Content skillContent;
                        ContentValue parentMacroSkillValue;
                        Optional optionalContent = skillValue.getContentIfExists();
                        if (!optionalContent.isPresent() || (parentMacroSkillValue = (ContentValue)(skillContent = (Content)optionalContent.get()).getValue("parentMacroSkill")) == null || !(optionalParentMacroSkill = parentMacroSkillValue.getContentIfExists()).isPresent()) continue;
                        ModifiableContent parentMacroSkill = (ModifiableContent)optionalParentMacroSkill.get();
                        String parentMacroSkillId = parentMacroSkill.getId();
                        HashMap<String, String> macroSkillMap = new HashMap<String, String>();
                        if (!createdMacroSkillNode.containsKey(parentMacroSkillId)) {
                            macroSkillMap.put("id", parentMacroSkillId);
                            macroSkillMap.put("title", parentMacroSkill.getTitle());
                            macroSkillMap.put("type", "MACROSKILL");
                            macroSkillMap.put("parentProgram", programId);
                            StringElement parentNode = new StringElement("skill", macroSkillMap);
                            createdMacroSkillNode.put(parentMacroSkillId, parentNode);
                            result.add(parentNode);
                        }
                        HashMap<String, String> skillMap = new HashMap<String, String>();
                        skillMap.put("id", skillContent.getId());
                        skillMap.put("title", skillContent.getTitle());
                        skillMap.put("type", "MICROSKILL");
                        skillMap.put("parent", parentMacroSkillId);
                        StringElement node = new StringElement("skill", skillMap);
                        result.add(node);
                    }
                }
            }
        }
        return new AmetysNodeList(result);
    }

    private static Pair<ProgramItem, List<EducationalPath>> _getCurrentEducationalPaths() {
        Request request = ContextHelper.getRequest((Context)_context);
        Page page = (Page)request.getAttribute(WebConstants.REQUEST_ATTR_PAGE);
        if (page != null) {
            if (page instanceof CoursePage) {
                CoursePage coursePage = (CoursePage)page;
                Course course = coursePage.getContent();
                return Pair.of((Object)course, (Object)course.getCurrentEducationalPaths());
            }
            if (page instanceof ProgramPage) {
                ProgramPage programPage = (ProgramPage)page;
                AbstractProgram abstractProgram = programPage.getContent();
                return Pair.of((Object)abstractProgram, (Object)abstractProgram.getCurrentEducationalPaths());
            }
        }
        Content content = (Content)request.getAttribute(Content.class.getName());
        return OdfXSLTHelper._getCurrentEducationalPaths(content);
    }

    private static Pair<ProgramItem, List<EducationalPath>> _getCurrentEducationalPaths(Content content) {
        Request request = ContextHelper.getRequest((Context)_context);
        if (content != null && (content instanceof Course || content instanceof AbstractProgram)) {
            List<EducationalPath> currentEducationalPaths;
            if (content instanceof Course) {
                Course course = (Course)content;
                v0 = course.getCurrentEducationalPaths();
            } else {
                v0 = currentEducationalPaths = ((AbstractProgram)content).getCurrentEducationalPaths();
            }
            if (currentEducationalPaths == null) {
                List pathFromRequest = (List)request.getAttribute(EducationalPathHelper.PROGRAM_ITEM_ANCESTOR_PATH_REQUEST_ATTR);
                if (pathFromRequest != null) {
                    currentEducationalPaths = _odfHelper.getEducationPathFromPath(pathFromRequest);
                    ProgramItem ancestor = (ProgramItem)request.getAttribute(EducationalPathHelper.ROOT_PROGRAM_ITEM_REQUEST_ATTR);
                    if (ancestor != null) {
                        currentEducationalPaths = currentEducationalPaths.stream().filter(p -> p.getProgramItemIds().contains(ancestor.getId())).toList();
                    }
                } else {
                    currentEducationalPaths = _odfHelper.getEducationalPaths((ProgramItem)content, true, true);
                }
            }
            return Pair.of((Object)((ProgramItem)content), (Object)currentEducationalPaths);
        }
        return null;
    }

    public static String isPartOfCurrentEducationalPaths(String educationPath) {
        return OdfXSLTHelper._isPartOfCurrentEducationalPaths(educationPath).name();
    }

    private static EducationaPathContextResult _isPartOfCurrentEducationalPaths(String educationPath) {
        EducationalPath educationalPath = EducationalPath.of((String[])educationPath.split(";"));
        List currentEducationalPaths = (List)OdfXSLTHelper._getCurrentEducationalPaths().getRight();
        if (currentEducationalPaths.contains(educationalPath)) {
            return currentEducationalPaths.size() > 1 ? EducationaPathContextResult.TRUE : EducationaPathContextResult.TRUE_EXACTLY;
        }
        return EducationaPathContextResult.FALSE;
    }

    public static String getMainStructureEducationalPathAsString(String educationalPath) {
        EducationalPath educationPath = EducationalPath.of((String[])educationalPath.split(";"));
        return educationPath != null ? _odfHelper.getEducationalPathAsString(educationPath, pi -> ((Content)pi).getTitle(), (CharSequence)" > ", pi -> OdfXSLTHelper._filterProgramItemInPath(pi)) : null;
    }

    private static boolean _filterProgramItemInPath(ProgramItem p) {
        return p instanceof AbstractProgram || _odfHelper.isContainerOfTypeYear((Content)p);
    }

    public static double getCurrentEcts(String defaultValue) {
        double currentEcts = OdfXSLTHelper.getCurrentEcts();
        return currentEcts != 0.0 ? currentEcts : (StringUtils.isNotEmpty((String)defaultValue) ? Double.valueOf(defaultValue) : 0.0);
    }

    public static boolean areECTSEqual(String courseId) {
        Course course = (Course)_ametysObjectResolver.resolveById(courseId);
        return OdfXSLTHelper._areECTSEqual(course);
    }

    public static boolean areECTSEqual() {
        Request request = ContextHelper.getRequest((Context)_context);
        Content content = (Content)request.getAttribute(Content.class.getName());
        if (content != null && content instanceof Course) {
            Course course = (Course)content;
            return OdfXSLTHelper._areECTSEqual(course);
        }
        return false;
    }

    private static boolean _areECTSEqual(Course course) {
        Pair<ProgramItem, List<EducationalPath>> currentEducationalPaths = OdfXSLTHelper._getCurrentEducationalPaths((Content)course);
        if (currentEducationalPaths != null) {
            ProgramItem programItem = (ProgramItem)currentEducationalPaths.getLeft();
            List paths = (List)currentEducationalPaths.getRight();
            return paths != null ? _odfHelper.isSameValueForPaths(programItem, "ectsByEducationalPath/ects", paths) : _odfHelper.isSameValueForAllPaths(programItem, "ectsByEducationalPath/ects");
        }
        return _odfHelper.isSameValueForAllPaths((ProgramItem)course, "ectsByEducationalPath/ects");
    }

    public static boolean areSkillsUnavailable(String programItemId, String programPageItemId) {
        if (StringUtils.isBlank((String)programItemId) || StringUtils.isBlank((String)programPageItemId)) {
            return false;
        }
        ProgramItem programItem = (ProgramItem)_ametysObjectResolver.resolveById(programItemId);
        if (programItem instanceof Program) {
            return _odfSkillsHelper.isExcluded(programItem);
        }
        Page programItemPage = (Page)_ametysObjectResolver.resolveById(programPageItemId);
        ProgramPage closestProgramPage = OdfXSLTHelper._getClosestProgramPage(programItemPage);
        AbstractProgram closestProgramOrSubprogram = closestProgramPage.getProgram();
        ProgramItem parent = _odfHelper.getParentProgramItem(programItem, closestProgramOrSubprogram);
        while (parent != null && !(parent instanceof Program)) {
            if (_odfSkillsHelper.isExcluded(parent)) {
                return true;
            }
            if (closestProgramOrSubprogram instanceof SubProgram && closestProgramOrSubprogram.equals((Object)parent)) {
                closestProgramOrSubprogram = ((ProgramPage)closestProgramPage.getParent()).getProgram();
            }
            parent = _odfHelper.getParentProgramItem(parent, closestProgramOrSubprogram);
        }
        return parent != null ? _odfSkillsHelper.isExcluded(parent) : false;
    }

    private static ProgramPage _getClosestProgramPage(Page page) {
        Page parentPage = (Page)page.getParent();
        while (!(parentPage instanceof ProgramPage)) {
            parentPage = (Page)parentPage.getParent();
        }
        return (ProgramPage)parentPage;
    }

    public static NodeList getProgramItemPages(String programItemId, String lang, String siteName) {
        ProgramItem currentProgramItem = (ProgramItem)_ametysObjectResolver.resolveById(programItemId);
        ArrayList pages = new ArrayList();
        for (Content content : _odfHelper.getProgramItems(List.of(), currentProgramItem.getCode(), null, lang)) {
            if (!(content instanceof ProgramItem)) continue;
            ProgramItem programItem = (ProgramItem)content;
            Catalog catalog = _catalogsManager.getCatalog(programItem.getCatalog());
            _odfPageResolver.getReferencingPages(programItem, siteName, lang).stream().findFirst().map(AmetysObject::getId).map(pageId -> new MapElement("page", Map.of("isCurrentCatalog", String.valueOf(programItem.getCatalog().equals(currentProgramItem.getCatalog()))), Map.of("pageId", pageId, "catalog", catalog.getTitle()))).ifPresent(pages::add);
        }
        return new AmetysNodeList(pages);
    }

    public static enum EducationaPathContextResult {
        FALSE,
        TRUE,
        TRUE_EXACTLY;

    }
}

