/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.cart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.core.cocoon.JSonReader;
import org.ametys.plugins.odfweb.cart.ODFCartManager.ODFCartItem;
import org.ametys.web.WebHelper;

/**
 * Get the view for each cart items
 *
 */
public class GetCartItemViewAction extends ServiceableAction
{
    private ODFCartManager _cartManager;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _cartManager = (ODFCartManager) smanager.lookup(ODFCartManager.ROLE);
    }
    
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Request request = ObjectModelHelper.getRequest(objectModel);

        List<Map<String, Object>> items = new ArrayList<>();
        
        String siteName = WebHelper.getSiteName(request);
        String[] itemsIds = request.getParameter("itemIds").split(",");
        String view = request.getParameter("view");
        
        for (String itemId : itemsIds)
        {
            ODFCartItem item = _cartManager.getCartItem(itemId); 
            if (item != null)
            {
                items.add(_cartManager.cartItem2Json(item, siteName, view));
            }
            else
            {
                getLogger().warn("The cart's item with id '" + itemId + "' does not match existing content. It will be ignored");
            }
        }
        
        Map<String, Object> result = new HashMap<>();
        result.put("items", items);
        
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }
    

}
