/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.observation;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfweb.repository.FirstLevelPageFactory;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.VirtualFactoryExpression;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageQueryHelper;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Request;

public abstract class AbstractODFObserver
extends AbstractLogEnabled
implements Observer,
Serviceable,
Contextualizable {
    protected org.apache.avalon.framework.context.Context _context;
    protected Context _cocoonContext;
    protected AmetysObjectResolver _resolver;
    protected ODFHelper _odfHelper;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = context;
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
    }

    protected String _workspaceToUse() {
        return "default";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Request request = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)this._workspaceToUse());
            AmetysObjectIterable<Page> rootPages = this._getODFRootPages();
            if (rootPages.getSize() == 0L) {
                this.getLogger().debug("There is no ODF root page, nothing to invalidate");
                return;
            }
            Set<Program> programs = this._getPrograms(event);
            if (programs.size() == 0) {
                this.getLogger().debug("There is no concerned programs");
                return;
            }
            for (Page odfRootPage : rootPages) {
                this._internalObserve(event, transientVars, odfRootPage, programs, this._getSubProgram(event), this._getCourse(event));
            }
        }
        catch (Exception e) {
            this.getLogger().error("Unable to observe event: {}", (Object)event, (Object)e);
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }

    protected abstract void _internalObserve(Event var1, Map<String, Object> var2, Page var3, Set<Program> var4, SubProgram var5, Course var6) throws Exception;

    protected AmetysObjectIterable<Page> _getODFRootPages() {
        VirtualFactoryExpression expression = new VirtualFactoryExpression(FirstLevelPageFactory.class.getName());
        String query = PageQueryHelper.getPageXPathQuery(null, null, null, (Expression)expression, null);
        return this._resolver.query(query);
    }

    protected Content _getContentArgument(Event event) throws Exception {
        return (Content)event.getArguments().get("content");
    }

    protected SubProgram _getSubProgram(Event event) throws Exception {
        Content content = this._getContentArgument(event);
        if (content instanceof SubProgram) {
            return (SubProgram)content;
        }
        return null;
    }

    protected Course _getCourse(Event event) throws Exception {
        Content content = this._getContentArgument(event);
        if (content instanceof Course) {
            return (Course)content;
        }
        return null;
    }

    protected Set<Program> _getPrograms(Event event) throws Exception {
        Content content = this._getContentArgument(event);
        if (content instanceof Program) {
            Program program = (Program)content;
            return Collections.singleton(program);
        }
        if (content instanceof ProgramItem) {
            ProgramItem programItem = (ProgramItem)content;
            return this._odfHelper.getParentPrograms(programItem);
        }
        if (content instanceof CoursePart) {
            CoursePart coursePart = (CoursePart)content;
            return this._odfHelper.getParentPrograms(coursePart);
        }
        this.getLogger().debug("This observer only handles ODF contents for virtual pages");
        return Collections.emptySet();
    }
}

