/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.repository;

import java.util.Set;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.UnknownZoneException;
import org.ametys.web.repository.page.Zone;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.commons.lang.StringUtils;

public class RedirectPage
implements Page {
    private Page _page;

    public RedirectPage(Page page) {
        this._page = page;
    }

    public Page getRedirectPage() {
        return this._page;
    }

    public Page.PageType getType() throws AmetysRepositoryException {
        return Page.PageType.LINK;
    }

    public String getURL() throws AmetysRepositoryException {
        return this._page.getId();
    }

    public Page.LinkType getURLType() throws AmetysRepositoryException {
        return Page.LinkType.PAGE;
    }

    public Sitemap getSitemap() throws AmetysRepositoryException {
        return this._page.getSitemap();
    }

    public String getSitemapName() throws AmetysRepositoryException {
        return this._page.getSitemapName();
    }

    public String getPathInSitemap() throws AmetysRepositoryException {
        return this.getParent().getPathInSitemap() + "/" + this.getName();
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages() throws AmetysRepositoryException {
        return this._addRedirects((AmetysObjectIterable<? extends AmetysObject>)this._page.getChildrenPages());
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages(boolean includeInvisiblePages) throws AmetysRepositoryException {
        return this._addRedirects((AmetysObjectIterable<? extends AmetysObject>)this._page.getChildrenPages(includeInvisiblePages));
    }

    public Page getChildPageAt(int index) throws UnknownAmetysObjectException, AmetysRepositoryException {
        return (Page)this._addRedirect((AmetysObject)this._page.getChildPageAt(index));
    }

    public <A extends AmetysObject> AmetysObjectIterable<A> getChildren() throws AmetysRepositoryException {
        return this._addRedirects((AmetysObjectIterable<? extends AmetysObject>)this._page.getChildren());
    }

    public boolean hasChild(String name) throws AmetysRepositoryException {
        return this._page.hasChild(name);
    }

    public <A extends AmetysObject> A getChild(String path) throws AmetysRepositoryException, UnknownAmetysObjectException {
        return this._addRedirect(this._page.getChild(path));
    }

    public String getName() throws AmetysRepositoryException {
        return this._page.getName();
    }

    public String getPath() throws AmetysRepositoryException {
        return this.getParentPath() + "/" + this.getName();
    }

    public String getId() throws AmetysRepositoryException {
        return StringUtils.replace((String)this._page.getId(), (String)"program://", (String)"unused://");
    }

    public String getTitle() throws AmetysRepositoryException {
        return this._page.getTitle();
    }

    public String getLongTitle() throws AmetysRepositoryException {
        return this._page.getLongTitle();
    }

    public Page getParent() throws AmetysRepositoryException {
        return (Page)this._page.getParent();
    }

    public String getParentPath() throws AmetysRepositoryException {
        return this._page.getParentPath();
    }

    public String getSiteName() throws AmetysRepositoryException {
        return this._page.getSiteName();
    }

    public Site getSite() throws AmetysRepositoryException {
        return this._page.getSite();
    }

    public ModelLessDataHolder getDataHolder() {
        return this._page.getDataHolder();
    }

    public Set<String> getTags() throws AmetysRepositoryException {
        return this._page.getTags();
    }

    public int getDepth() throws AmetysRepositoryException {
        return this._page.getDepth();
    }

    public String getTemplate() throws AmetysRepositoryException {
        return this._page.getTemplate();
    }

    public AmetysObjectIterable<? extends Zone> getZones() throws AmetysRepositoryException {
        return this._page.getZones();
    }

    public boolean hasZone(String name) throws AmetysRepositoryException {
        return this._page.hasZone(name);
    }

    public Zone getZone(String name) throws UnknownZoneException, AmetysRepositoryException {
        return this._page.getZone(name);
    }

    public ResourceCollection getRootAttachments() throws AmetysRepositoryException {
        throw new UnsupportedOperationException("getRootAttachments not supported on legacy redirect odf pages");
    }

    public Set<String> getReferers() throws AmetysRepositoryException {
        throw new UnsupportedOperationException("getReferers not supported on legacy redirect odf pages");
    }

    public boolean isVisible() throws AmetysRepositoryException {
        return false;
    }

    public boolean isIndexable() throws AmetysRepositoryException {
        return false;
    }

    public ModelAwareDataHolder getTemplateParametersHolder() throws AmetysRepositoryException {
        return null;
    }

    private <A extends AmetysObject> A _addRedirect(AmetysObject ametysObject) {
        Object object;
        if (ametysObject instanceof Page) {
            Page page;
            Page page2 = (Page)ametysObject;
            if (page2 instanceof RedirectPage) {
                RedirectPage redirectPage = (RedirectPage)page2;
                page = redirectPage.getRedirectPage();
            } else {
                page = page2;
            }
            object = new RedirectPage(page);
        } else {
            object = ametysObject;
        }
        return (A)object;
    }

    private <A extends AmetysObject> AmetysObjectIterable<A> _addRedirects(AmetysObjectIterable<? extends AmetysObject> iterable) {
        return new CollectionIterable(iterable.stream().map(this::_addRedirect).toList());
    }
}

