/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.tree;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import org.ametys.cms.repository.Content;
import org.ametys.odf.course.Course;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * {@link ODFTreeIndicator} to indicate if a course has shared course part
 */
public class SharedCoursePartIndicator extends AbstractStaticODFTreeIndicator
{
    public IndicatorData getIndicatorData(Content content)
    {
        if (content instanceof Course course)
        {
            if (_hasSharedCoursePart(course))
            {
                return new IndicatorData(new I18nizableText("plugin.odf", "PLUGINS_ODF_CONTENTS_TREE_INDICATORS_HAS_SHARED_COURSE_PART"), null, "odficon-course-part-shared", Map.of());
            }
        }
        
        return null;
    }
    
    private boolean _hasSharedCoursePart(Course content)
    {
        return content.getCourseParts().stream()            // parcourt toutes les heures d'enseignement du cours
            .map(CoursePart::getCourses)                    // récupère la liste des cours lié à chaque heure d'enseignement
            .flatMap(List::stream)                          // parcourt la liste
            .anyMatch(c -> !StringUtils.equals(c.getId(), content.getId()));   // vérifie si un des cours n'est pas le cours actuel
    }
}
