<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
			    xmlns:docbook="http://docbook.org/ns/docbook"
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:fo="http://www.w3.org/1999/XSL/Format"
			    xmlns:cms="http://ametys.org/cms/3.0"
				xmlns:date="http://exslt.org/dates-and-times"
                xmlns:odf="org.ametys.odf.OdfXSLTHelper"
			    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
				xmlns:stringutils="org.apache.commons.lang.StringUtils"
			    exclude-result-prefixes="docbook"
			    extension-element-prefixes="cms date resolver stringutils">

    <xsl:import href="plugin:cms://stylesheets/helper/common.xsl"/>
    <xsl:import href="view:cms://stylesheets/io/docbook2fo.xsl" />
	<xsl:import href="plugin:odf://stylesheets/content/common2pdf.xsl"/>
		
	<xsl:param name="contextPath" />
	
    <xsl:template match="/">
        <fo:root>
            <fo:layout-master-set>
                <fo:simple-page-master master-name="page"
                    page-width="210mm" page-height="297mm" margin-left="0cm"
                    margin-right="0cm" margin-top="2cm" margin-bottom="2cm">
                    <fo:region-body margin-top="0cm" margin-bottom="1cm">
                        <xsl:call-template name="region-body-definition"/>
                    </fo:region-body>
                    <fo:region-before extent="1cm">
                        <xsl:call-template name="region-before-definition"/>
                    </fo:region-before>
                    <fo:region-after extent="0.5cm">
                        <xsl:call-template name="region-after-definition"/>
                    </fo:region-after>
                </fo:simple-page-master>
            </fo:layout-master-set>
            
            <xsl:apply-templates />
        </fo:root>
    </xsl:template>
    
    <xsl:template name="xsl-region-before">
    </xsl:template>
    
	<!--+
		+  PAGE CONTENT
		+ -->	
	<xsl:template match="content">
		<fo:page-sequence master-reference="page">
            
            <xsl:call-template name="xsl-region-before"/>
            
            <xsl:call-template name="xsl-region-after"/>
            
	        <!-- Body region -->	
 			<fo:flow flow-name="xsl-region-body">
                <fo:block margin-left="1cm" margin-right="1cm">
                    <xsl:call-template name="main-body-block"/>
                    
                    <fo:block margin-left="0cm" margin-right="0cm">
    					<xsl:call-template name="header"/>
    					<xsl:call-template name="body"/>
                    </fo:block>
				</fo:block>
				<fo:block id="theEnd" />
			</fo:flow>
			
		</fo:page-sequence>	
	</xsl:template>
    
    <xsl:template name="xsl-region-after">
        <fo:static-content flow-name="xsl-region-after">
            <fo:block margin-left="1cm" margin-right="1cm">
                <xsl:call-template name="main-region-after-block"/>
                
                <fo:table table-layout="fixed" margin-top="0pt" padding-top="0pt">
                <fo:table-column column-width="4.5cm"/>
                <fo:table-column column-width="10cm"/>
                <fo:table-column column-width="4.5cm"/>
                <fo:table-body>
                    <fo:table-row>
                        <fo:table-cell>
                            <fo:block text-align="left">
                                <xsl:variable name="now" select="date:date-time()"/>
                                <xsl:number format="01" value="date:day-in-month($now)"/>
                                <xsl:text>/</xsl:text>
                                <xsl:number format="01" value="date:month-in-year($now)"/>
                                <xsl:text>/</xsl:text>
                                <xsl:value-of select="date:year($now)"/>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block text-align="center" font-size="5px">
                                <i18n:text i18n:key="PLUGINS_ODF_PDF_CATALOG_FOOTER_TEXT" i18n:catalogue="plugin.odf"/>
                            </fo:block>
                        </fo:table-cell>
                        <fo:table-cell>
                            <fo:block text-align="right"><i18n:text i18n:key="PLUGINS_ODF_PDF_CATALOG_FOOTER_PAGE_NUMBER" i18n:catalogue="plugin.odf"/> <fo:page-number /> / <fo:page-number-citation ref-id="theEnd" /></fo:block>
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>
            </fo:block>
        </fo:static-content> 
    </xsl:template>
	
	<xsl:template name="title">
        <fo:block>
        	<xsl:call-template name="title-style">
            	<xsl:with-param name="level" select="'2'"/>
            </xsl:call-template>
            <xsl:variable name="title"><xsl:value-of select="metadata/title"/></xsl:variable>
            <xsl:value-of select="stringutils:upperCase($title)"/>
        </fo:block>
	</xsl:template>
    
    <xsl:template name="header-top">
    </xsl:template>
    
    <xsl:template name="header-bottom">
    </xsl:template>

	<xsl:template name="header">
		<xsl:call-template name="header-top"/>
        
        <xsl:call-template name="title"/>
        
		<xsl:call-template name="header-bottom"/>
	</xsl:template>
	
	<xsl:template name="body-top">
	</xsl:template>
	
	<xsl:template name="body-bottom">
	</xsl:template>
	
    <xsl:template name="body">
        <xsl:call-template name="body-top"/>
        
        <fo:block space-before="0.5cm">
            <fo:block>
                <fo:table table-layout="fixed">
                    <fo:table-column column-width="13cm"/>
                    <fo:table-column column-width="6cm"/>
                    <fo:table-body>
                        <fo:table-row>
                            <fo:table-cell margin-left="0cm" margin-right="0cm">
                                <fo:block>
                                	<xsl:call-template name="body-content">
                                		<xsl:with-param name="truelevel" select="2"/>
                                	</xsl:call-template>
                                </fo:block>
                            </fo:table-cell>
                            <fo:table-cell margin-left="0cm" margin-right="0cm" padding-left="3pt">
                                <fo:block>
                                	<xsl:call-template name="right-content">
                                		<xsl:with-param name="truelevel" select="2"/>
                                	</xsl:call-template>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:block>
        
        <xsl:call-template name="body-bottom"/>
    </xsl:template>
    
    <xsl:template name="body-content">
    	<xsl:param name="truelevel"/>
    	
    	<!-- Présentation -->
    	<xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/description"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:CONTENT_COURSE_PRESENTATION'"/>
        </xsl:call-template>
        
        <!-- Objectifs -->
        <xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/objectives"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:CONTENT_COURSE_OBJECTIVES'"/>
        </xsl:call-template>
        
		<!-- Pré-requis --> 
		<xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/neededPrerequisite"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:CONTENT_COURSE_NEEDED_PREREQUISITE'"/>
        </xsl:call-template>
        
        <!-- Programme -->
        <xsl:if test="courseList">
        	<fo:block>
				<xsl:call-template name="para-style"/>
	            <fo:list-block>
	            	<xsl:call-template name="ol-style"/>
	                <xsl:apply-templates select="courseList"/>
	            </fo:list-block>
	        </fo:block>
        </xsl:if>
        
        <!-- Compétences -->
         <xsl:call-template name="common-content-richtext2pdf-field">
             <xsl:with-param name="value" select="metadata/skills"/>
             <xsl:with-param name="level" select="$truelevel + 1"/>
             <xsl:with-param name="title" select="'plugin.odf:PLUGINS_ODF_COURSE_SKILLS'"/>
         </xsl:call-template> 
         
         <!-- Examens -->
        <xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/formOfAssessment"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:CONTENT_COURSE_FORM_OF_ASSESSMENT'"/>
        </xsl:call-template>            
                    
        <!-- Syllabus -->
         <xsl:call-template name="common-content-richtext2pdf-field">
             <xsl:with-param name="value" select="metadata/syllabus"/>
             <xsl:with-param name="level" select="$truelevel + 1"/>
             <xsl:with-param name="title" select="'plugin.odf:CONTENT_COURSE_SYLLABUS'"/>
         </xsl:call-template>
        
        <!-- Bibliographie -->
        <xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/bibliography"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:PLUGINS_ODF_COURSE_BIBLIO'"/>
        </xsl:call-template> 
        
        <!-- Informations supplémentaires -->
        <xsl:call-template name="common-content-richtext2pdf-field">
            <xsl:with-param name="value" select="metadata/additionalInformations"/>
            <xsl:with-param name="level" select="$truelevel + 1"/>
            <xsl:with-param name="title" select="'plugin.odf:CONTENT_COURSE_ADDITIONAL_INFORMATIONS'"/>
        </xsl:call-template> 
    </xsl:template>
    
   	
	<xsl:template name="right-content">
		<xsl:param name="truelevel"/>
		
		<xsl:call-template name="brief">
            <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
        
        <xsl:call-template name="contacts">
            <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
        
        <xsl:call-template name="more-info">
            <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
	</xsl:template>
    
    <xsl:template name="brief">
        <fo:block xsl:use-attribute-sets="right-block">
			<fo:block xsl:use-attribute-sets="right-block-header">
                 <i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_BRIEF"/>
            </fo:block>
            <fo:block xsl:use-attribute-sets="right-block-body">
                <!-- Degree -->
                <xsl:if test="metadata/ects ">
                    <fo:block>
                        <fo:inline font-weight="bold"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_ECTS"/><xsl:text> : </xsl:text></fo:inline>
                        <fo:inline><xsl:value-of select="metadata/ects"/></fo:inline>
                    </fo:block>
                </xsl:if>
                    
                <xsl:if test="normalize-space(metadata/numberOfStudents) != ''">
                    <fo:block>
                        <fo:inline font-weight="bold"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_MAX_NUMBER_OF_STUDENTS"/><xsl:text> : </xsl:text></fo:inline>
                        <fo:inline><xsl:value-of select="metadata/numberOfStudents"/></fo:inline>
                    </fo:block>
                </xsl:if>
                
                <!-- Nombre d'heure -->
                <xsl:if test="normalize-space(metadata/nbHours) != ''">
                    <fo:block>
                        <fo:inline font-weight="bold"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_NB_HOURS"/><xsl:text> : </xsl:text></fo:inline>
                        <fo:inline><xsl:value-of select="metadata/nbHours"/></fo:inline>
                    </fo:block>
                </xsl:if>
                
                <!-- Niveau d'étude -->            
                <xsl:if test="metadata/level">
                    <fo:block>
                        <fo:inline font-weight="bold"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_LEVEL"/><xsl:text> : </xsl:text></fo:inline>
                        <fo:inline><xsl:value-of select="metadata/level/@title"/></fo:inline>
                    </fo:block>
                </xsl:if>
            
                <!-- Periode de l'année -->
                <xsl:if test="metadata/teachingTerm">
                    <fo:block>
                        <fo:inline font-weight="bold"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_TEACHING_TERM"/><xsl:text> : </xsl:text></fo:inline>
                        <fo:inline><xsl:value-of select="metadata/teachingTerm/@title"/></fo:inline>
                    </fo:block>
                </xsl:if>
                            
                <!-- Plage horaire -->                        
                <xsl:if test="metadata/timeSlot">
                    <fo:block>
                        <fo:inline font-weight="bold"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_TIME_SLOT"/><xsl:text> : </xsl:text></fo:inline>
                        <fo:inline><xsl:value-of select="metadata/timeSlot/@title"/></fo:inline>
                    </fo:block>
                </xsl:if>                        
                    
                <!-- Méthode d'enseignement -->
                <xsl:if test="metadata/formofteachingMethod">
                    <fo:block>
                        <fo:inline font-weight="bold"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_FORM_OF_TEACHING_METHOD"/><xsl:text> : </xsl:text></fo:inline>
                        <fo:inline><xsl:value-of select="metadata/formofteachingMethod/@title"/></fo:inline>
                    </fo:block>
                </xsl:if>            
                
                <!-- Forme d'enseignement -->
                <xsl:if test="metadata/teachingActivity">
                    <fo:block>
                        <fo:inline font-weight="bold"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_TEACHING_ACTIVITY"/><xsl:text> : </xsl:text></fo:inline>
                        <fo:inline><xsl:value-of select="metadata/teachingActivity/@title"/></fo:inline>
                    </fo:block>
                </xsl:if>
                
                <!-- Type de formation -->
                <xsl:if test="metadata/formofteachingOrg">
                    <fo:block>
                        <fo:inline font-weight="bold"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_FORM_OF_TEACHING_ORG"/><xsl:text> : </xsl:text></fo:inline>
                        <fo:inline>
                            <xsl:for-each select="metadata/formofteachingOrg">
                                <fo:list-item>
                                    <fo:list-item-label>
                                        <fo:block>* </fo:block>
                                    </fo:list-item-label>
                                    <fo:list-item-body start-indent="body-start()-5mm">
                                        <fo:block><xsl:value-of select="@title"/></fo:block>
                                    </fo:list-item-body>
                                </fo:list-item>
                            </xsl:for-each>
                        </fo:inline>
                    </fo:block>
                </xsl:if>
             
                <!-- Langue d'enseignement -->
                <xsl:if test="normalize-space(metadata/teachingLanguage) != ''">
                    <fo:block>
                        <fo:inline font-weight="bold"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_TEACHING_LANGUAGE"/><xsl:text> : </xsl:text></fo:inline>
                        <fo:inline>
                            <xsl:for-each select="metadata/teachingLanguage">
                                <fo:list-item>
                                    <fo:list-item-label>
                                        <fo:block>* </fo:block>
                                    </fo:list-item-label>
                                    <fo:list-item-body start-indent="body-start()-5mm">
                                        <fo:block><xsl:value-of select="@title"/></fo:block>
                                    </fo:list-item-body>
                                </fo:list-item>
                            </xsl:for-each>
                        </fo:inline>
                    </fo:block>
                </xsl:if>            
                
                <!-- Date de début des cours -->            
                <xsl:if test="normalize-space(metadata/startDate) != ''">
                    <fo:block>
                        <fo:inline font-weight="bold"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_START_DATE"/><xsl:text> : </xsl:text></fo:inline>
                        <fo:inline><i18n:date value="{metadata/startDate}" src-pattern="yyyy-MM-dd'T'HH:mm" pattern="long"/></fo:inline>
                    </fo:block>
                </xsl:if>          
            </fo:block>
        </fo:block>
    </xsl:template>
    
    <xsl:template name="contacts">
        <xsl:param name="truelevel"/>
        
    
        <xsl:if test="metadata/contacts/entry/persons or metadata/orgUnit or metadata/teachingLocation or metadata/campus">
            <fo:block xsl:use-attribute-sets="right-block">
                <fo:block xsl:use-attribute-sets="right-block-header">
                     <i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_CONTACT"/>
                </fo:block>
                <fo:block xsl:use-attribute-sets="right-block-body">
                    <xsl:if test="metadata/orgUnit">
                         <fo:block>
                            <fo:inline font-weight="bold"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_ORGUNIT"/></fo:inline>
                        </fo:block>
                         <xsl:for-each select="metadata/orgUnit">
                            <fo:block><xsl:value-of select="@title"/></fo:block>  
                        </xsl:for-each>    
                     </xsl:if>
                     
                     
                     <xsl:for-each select="metadata/contacts/entry">
                        <fo:block>
                            <xsl:if test="normalize-space(role/@title) != ''">
                                <fo:block>
                                    <fo:inline font-weight="bold"><xsl:value-of select="role/@title"/></fo:inline>
                                </fo:block>
                            </xsl:if>
                            <xsl:for-each select="persons">
                                <fo:block><xsl:value-of select="@title"/></fo:block>  
                            </xsl:for-each> 
                        </fo:block>  
                    </xsl:for-each>
                    
                    <xsl:if test="metadata/teachingLocation">
                        <fo:block>
                            <fo:block>
                                <fo:inline font-weight="bold"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_PLACE"/></fo:inline>
                            </fo:block>
                            <xsl:for-each select="metadata/teachingLocation">
                                <fo:block><xsl:value-of select="@title"/></fo:block>
                            </xsl:for-each>
                        </fo:block>
                    </xsl:if>
                    
                    <xsl:if test="metadata/campus">
                        <fo:block>
                            <fo:block>
                                <fo:inline font-weight="bold"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_CAMPUS"/></fo:inline>
                            </fo:block>
                            <xsl:for-each select="metadata/campus">
                                <fo:block><xsl:value-of select="@title"/></fo:block>
                            </xsl:for-each>
                        </fo:block>
                    </xsl:if>
                </fo:block>
            </fo:block>
        </xsl:if>
    </xsl:template>
    
	<!-- +
	     | RIGHT CONTENT : Plus d'infos
	     + -->
	<xsl:template name="more-info">
        <xsl:param name="truelevel"/>
        
	</xsl:template>
	
	<!-- +
         | COURSE LIST
         + -->
	<xsl:template match="courseList">
        <xsl:param name="indent" select="0"/>
        <xsl:param name="level" select="0"/>
        
        <fo:list-item>
            <fo:list-item-label><fo:block></fo:block></fo:list-item-label>
		  	<fo:list-item-body start-indent="{$indent}pt">
		  		<fo:block>
		  			<xsl:call-template name="li-text-style-courselist">
		  				<xsl:with-param name="level" select="$level"/>
		  			</xsl:call-template>
		  			<fo:inline>
                        <xsl:text> - </xsl:text><xsl:value-of select="@title"/>
    		  			<xsl:if test="@type = 'MANDATORY'">
                            <fo:inline> (<i18n:text i18n:key="PLUGINS_ODF_COURSE_LIST_CONTENT_TYPE_MANDATORY" i18n:catalogue="plugin.odf"/>)</fo:inline>
                        </xsl:if>
    					<xsl:if test="@type = 'OPTIONAL'">
                            <fo:inline> (<i18n:text i18n:key="PLUGINS_ODF_COURSE_LIST_CONTENT_TYPE_OPTIONAL" i18n:catalogue="plugin.odf"/>)</fo:inline>
                        </xsl:if>
    		  			<xsl:if test="@type = 'CHOICE'">
                            <fo:inline>
                                <xsl:text> (</xsl:text><i18n:text i18n:key="PLUGINS_ODF_COURSE_LIST_CONTENT_TYPE_CHOICE" i18n:catalogue="plugin.odf"/>:&#160;
                                <xsl:value-of select="@min"/>&#160;<i18n:text i18n:key="PLUGINS_ODF_COURSE_LIST_CONTENT_MAX_ELP" i18n:catalogue="plugin.odf"/>&#160;
                                <xsl:value-of select="@max"/><xsl:text>)</xsl:text>
                            </fo:inline>
                        </xsl:if>
                    </fo:inline>
                    
                    <xsl:if test="course">
						<fo:list-block start-indent="{$indent}pt">	
							<xsl:call-template name="ol-style"/>
							<xsl:apply-templates select="course">
								<xsl:with-param name="indent" select="$indent + 10"/>
								<xsl:with-param name="level" select="$level + 1"/>
							</xsl:apply-templates>
						</fo:list-block>
					</xsl:if>
		  		</fo:block>
			</fo:list-item-body>
        </fo:list-item>
	</xsl:template>
	
	<!-- +
		 | COURSE
		 + -->
	<xsl:template match="course">
		<xsl:param name="indent" select="0"/>
		<xsl:param name="level" select="0"/>
		
		 <fo:list-item>
		  	<fo:list-item-label><fo:block></fo:block></fo:list-item-label>
		  	<fo:list-item-body start-indent="{$indent}pt"> 
		  		<fo:block>
		  			<xsl:call-template name="li-text-style-course">
		  				<xsl:with-param name="level" select="$level"/>
		  			</xsl:call-template>
					<fo:inline>
                        <xsl:text>&#183; </xsl:text><xsl:value-of select="@title"/>
    					<xsl:if test="@ects != '' and @ects != '0'">
                            <xsl:text> (</xsl:text><xsl:value-of select="@ects"/><xsl:text> ECTS)</xsl:text>
                        </xsl:if>
                    </fo:inline>
				</fo:block>
				<xsl:if test="courseList">
			  		<fo:block padding-bottom="8pt">
						<fo:list-block start-indent="{$indent + 10}pt">
							<xsl:call-template name="ol-style"/>
							<xsl:apply-templates select="courseList">
								<xsl:with-param name="indent" select="$indent + 10"/>
								<xsl:with-param name="level" select="$level + 1"/>
							</xsl:apply-templates>
						</fo:list-block>
					</fo:block>
				</xsl:if>
			</fo:list-item-body>
		</fo:list-item>
	</xsl:template>
    
    <!-- +
         | Default style
         + -->
    <xsl:template name="region-body-definition"/>
    
    <xsl:template name="region-before-definition"/>
    
    <xsl:template name="region-after-definition"/>
    
    <xsl:template name="main-body-block"/>
    
    <xsl:template name="main-region-after-block">
        <xsl:attribute name="font-size">9px</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="content-body-style"/>
    
    
    <xsl:attribute-set name="brief"/>
    <xsl:attribute-set name="brief-title"/>
    
    <xsl:attribute-set name="right-block"/>
    <xsl:attribute-set name="right-block-body"/>
    <xsl:attribute-set name="right-block-header"/>
    
    <xsl:template name="li-text-style-container">
		<xsl:param name="level"/>
	</xsl:template>
	<xsl:template name="li-text-style-courselist">
		<xsl:param name="level"/>
	</xsl:template>
	<xsl:template name="li-text-style-course">
		<xsl:param name="level"/>
	</xsl:template>
    
</xsl:stylesheet>
