<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:ametys="org.ametys.cms.transformation.xslt.AmetysXSLTHelper"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    exclude-result-prefixes="i18n xalan resolver">
    
    <xsl:import href="plugin:cms://pages/properties/view.xsl"/>
    
    <xsl:param name="currentParentId"/>
    
    <xsl:decimal-format grouping-separator=" " decimal-separator="," />
    
    <xsl:template match="/view">
        <xml>
            <title>
                <xsl:value-of select="/view/content/metadata/nature/code"/>
                <xsl:text> | </xsl:text>
                <xsl:value-of select="format-number(/view/content/metadata/nbHours, '#,##')"/><i18n:text i18n:catalogue="plugin.core-ui" i18n:key="PLUGINS_CORE_UI_DURATION_FORMAT_HOURS"/>
            </title>
            <display><xsl:call-template name="content-metadata"/></display>
        </xml>
    </xsl:template>
    
    <xsl:template match="*" mode="view">
        <xsl:param name="nodes"/>
        
        <xsl:for-each select="fieldset|metadata">
            <xsl:choose>
                <xsl:when test="@type='repeater'">
                    <p><strong><xsl:value-of select="label"/></strong></p>
                    
                    <xsl:variable name="repeater" select="current()"/>
                    <xsl:variable name="metadataName" select="@name"></xsl:variable>
                    <xsl:for-each select="$nodes[local-name() = $metadataName]/entry">
                        <div class="sub">
                            <p class="entry"><i18n:text i18n:catalogue="plugin.cms" i18n:key='UITOOL_DETAILS_REPEATER_ENTRY'/><xsl:text> </xsl:text><xsl:value-of select="@name"/></p>
                            <div class="subsub">
                                <xsl:apply-templates select="$repeater" mode="view">
                                    <xsl:with-param name="nodes" select="*"/>
                                </xsl:apply-templates>
                            </div>
                        </div>
                    </xsl:for-each>
                </xsl:when>
                <xsl:when test="local-name()='fieldset'">
                    <p><strong><xsl:value-of select="label"/></strong></p>
                    <div class="sub">
                        <xsl:apply-templates select="." mode="view">
                            <xsl:with-param name="nodes" select="$nodes"/>
                        </xsl:apply-templates>
                    </div>
                </xsl:when>
                <xsl:when test="@type='composite'">
                    <p><strong><xsl:value-of select="label"/></strong></p>
                    <div class="sub">
                        <xsl:apply-templates select="." mode="view">
                            <xsl:with-param name="nodes" select="xalan:nodeset($nodes/*)"/>
                        </xsl:apply-templates>
                    </div>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="metadataName" select="@name"></xsl:variable>
                    <xsl:choose>
                        <xsl:when test="$metadataName = 'courses'">
                            <xsl:if test="count($nodes[local-name() = $metadataName and @id != $currentParentId]) > 0">
                                <p>
                                    <strong><i18n:text i18n:key='PLUGINS_ODF_WIDGET_SELECT_COURSEPART_SHARED_WITH' i18n:catalogue='plugin.odf'/></strong>
                                    <xsl:apply-templates select="$nodes[local-name() = $metadataName and @id != $currentParentId]" mode="value">
                                        <xsl:with-param name="type" select="@type"/>
                                    </xsl:apply-templates>
                                </p>
                            </xsl:if>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:if test="count($nodes[local-name() = $metadataName]) > 0">
                                <p>
                                    <strong>
                                        <xsl:choose>
                                            <xsl:when test="$metadataName = 'courseHolder'"><i18n:text i18n:key='PLUGINS_ODF_WIDGET_SELECT_COURSEPART_HOLD_BY' i18n:catalogue='plugin.odf'/></xsl:when>
                                            <xsl:otherwise><xsl:value-of select="label"/><i18n:text i18n:key='PLUGINS_ODF_WIDGET_SELECT_COURSEPART_SEPARATOR' i18n:catalogue='plugin.odf'/></xsl:otherwise>
                                        </xsl:choose>
                                    </strong>
                                    <xsl:apply-templates select="$nodes[local-name() = $metadataName]" mode="value">
                                        <xsl:with-param name="type" select="@type"/>
                                    </xsl:apply-templates>
                                </p>
                            </xsl:if>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>

    