<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:cdmresolver="org.ametys.odf.xslt.CDMFrXSLTHelper"
                              xmlns:ametys="org.ametys.cms.transformation.xslt.AmetysXSLTHelper"
                              xmlns:ametys-cdm="http://www.ametys.org/cdm/1.0"
                              xmlns:xlink="http://www.w3.org/1999/xlink"
                              xmlns:xhtml="http://www.w3.org/1999/xhtml"
                			  xmlns:htmlexpertresolver="org.ametys.cms.transformation.xslt.HTMLExpertLinkResolver"
                              exclude-result-prefixes="docbook resolver xlink htmlexpertresolver ametys cdmresolver">
	
	<xsl:param name="contextPath"/>
    <xsl:param name="rawHtmlExpert">false</xsl:param>
	
    <xsl:template match="docbook:table">
        <xhtml:table>
            <xsl:if test="@width = '100%'">
                <xsl:attribute name="style">width: 100%;</xsl:attribute>
            </xsl:if>
            
            <xsl:copy-of select="@class"/>
            <xsl:copy-of select="@summary"/>
            <xsl:copy-of select="@align"/>
            
            <xsl:if test="@title">
                <xhtml:caption><xsl:value-of select="@title"/></xhtml:caption>
            </xsl:if>
 
            <xsl:apply-templates select="docbook:tbody"/>
        </xhtml:table>
    </xsl:template>
    
    <xsl:template match="docbook:tbody">
    	<xsl:choose>
    		<xsl:when test="../@title or ../@summary or docbook:tr/docbook:th">
        		<xhtml:tbody>
    	    	    <xsl:apply-templates select="docbook:tr"/>
	        	</xhtml:tbody>
    		</xsl:when>
    		<xsl:otherwise>
   	    	    <xsl:apply-templates select="docbook:tr"/>
    		</xsl:otherwise>
    	</xsl:choose>
    </xsl:template>
    
    <xsl:template match="docbook:tr">
        <xhtml:tr>
        	<xsl:attribute name="class">
        		<xsl:choose>
        			<xsl:when test="position() mod 2 = 0"><xsl:text>even</xsl:text></xsl:when>
        			<xsl:otherwise><xsl:text>odd</xsl:text></xsl:otherwise>
        		</xsl:choose>
        		<xsl:if test="docbook:td and not(preceding-sibling::*[docbook:td])"><xsl:text> first</xsl:text></xsl:if>
        		<xsl:if test="position() = last()"><xsl:text> last</xsl:text></xsl:if>
        	</xsl:attribute>
            <xsl:apply-templates select="docbook:td|docbook:th"/>
        </xhtml:tr>
    </xsl:template>
    
    <xsl:template match="docbook:td|docbook:th">
        <xsl:element name="xhtml:{local-name(.)}">
            <xsl:copy-of select="@colspan"/>
            <xsl:copy-of select="@rowspan"/>
            
            <xsl:variable name="style">
                <xsl:if test="@align">text-align: <xsl:value-of select="@align"/>;</xsl:if>
                <xsl:if test="@valign">vertical-align: <xsl:value-of select="@valign"/>;</xsl:if>
                <xsl:if test="@height">height: <xsl:value-of select="@height"/>;</xsl:if>
                <xsl:if test="@width">width: <xsl:value-of select="@width"/>;</xsl:if>
            </xsl:variable>
            
            <xsl:if test="$style != ''">
                <xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute>
            </xsl:if>
            
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>
    
    <xsl:template match="xhtml:htmlexpert">
        <xsl:choose>
            <xsl:when test="$rawHtmlExpert = 'true'">
                <ametys-cdm:htmlexpert>
                    <xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
                    <xsl:copy-of select="text()"/>    
                    <xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
                </ametys-cdm:htmlexpert>
            </xsl:when>
            <xsl:otherwise>
                <!-- Processing instruction to not touch the HTML produced -->
                <xsl:processing-instruction name="ametys-unmodifiable">start</xsl:processing-instruction> 
                <xsl:value-of disable-output-escaping="yes" select="htmlexpertresolver:parseAndResolve(.)"/>
                <xsl:processing-instruction name="ametys-unmodifiable">end</xsl:processing-instruction>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="xhtml:toc">
    </xsl:template>
    
    <xsl:template match="docbook:para[xhtml:toc]">
        <xsl:if test="following-sibling::docbook:section">
        	<list listType="numbered">
             	 <xsl:apply-templates select="following-sibling::docbook:section" mode="toc">
                  	<xsl:with-param name="level" select="'1'"/>
                  	<xsl:with-param name="style" select="'loweralpha'"/>
              	</xsl:apply-templates>
          	</list>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="docbook:section" mode="toc">
        <xsl:param name="level"/>
        <xsl:param name="style"/>
        <listItem>
	        <webLink>
	           <href>#<xsl:value-of select="generate-id()"/></href>
	           <linkName><xsl:value-of select="docbook:title"/></linkName>
	        </webLink>
            <xsl:if test="docbook:section">
        		<list listType="numbered">
                    <xsl:apply-templates select="docbook:section" mode="toc">
                        <xsl:with-param name="level" select="$level + 1"/>
                        <xsl:with-param name="style" select="'lowerroman'"/>
                    </xsl:apply-templates>
                </list>
            </xsl:if>
        </listItem>
    </xsl:template>
    
    <xsl:template name="get-styles">
        <xsl:copy-of select="@class"/>
    	<xsl:call-template name="get-style"/>
    </xsl:template>
    
    <xsl:template name="get-style">
        <xsl:variable name="style">
            <xsl:if test="@align">text-align:<xsl:value-of select="@align"/>;</xsl:if>
        </xsl:variable>
        <xsl:if test="$style != ''">
            <xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute>
        </xsl:if>
    </xsl:template>

	<xsl:template match="docbook:article">
		<xsl:apply-templates />
	</xsl:template>
	
    <xsl:template match="docbook:section">
        <subBlock>
            <xsl:if test="docbook:title/node()">
                <header><xsl:value-of select="docbook:title"/></header>
            </xsl:if>
            <xsl:apply-templates select="*[name() != 'title']"/>
        </subBlock>
    </xsl:template>
    
    <xsl:template match="docbook:para">
        <p>
            <xsl:apply-templates/>
        </p>
    </xsl:template>
    
    <xsl:template match="docbook:subscript">
        <xhtml:sub>
            <xsl:apply-templates/>
        </xhtml:sub>
    </xsl:template>
    
    <xsl:template match="docbook:supscript">
        <xhtml:sup>
            <xsl:apply-templates/>
        </xhtml:sup>
    </xsl:template>
    
    <xsl:template match="docbook:phrase[@role='linebreak']">
        <br/>
    </xsl:template>
    
    <xsl:template match="docbook:para" mode="listitem">
        <xsl:apply-templates/>
    </xsl:template>
    
    <xsl:template match="docbook:emphasis">
        <xsl:choose>
            <xsl:when test="@role='strong'">
                <bold><xsl:apply-templates/></bold>
            </xsl:when>
            <xsl:otherwise>
                <italic><xsl:apply-templates/></italic>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="docbook:itemizedlist">
        <list listType="bulleted">
            <xsl:apply-templates select="docbook:listitem"/>
        </list>
    </xsl:template>
    
    <xsl:template match="docbook:orderedlist">
        <list listType="numbered">
            <xsl:apply-templates select="docbook:listitem"/>
        </list>
    </xsl:template>
    
    <xsl:template match="docbook:itemizedlist|docbook:orderedlist" mode="listitem">
        <xsl:apply-templates select="."/>
    </xsl:template>
    
    <xsl:template match="docbook:listitem">
        <listItem>
            <xsl:apply-templates select="docbook:para" mode="listitem"/>
        </listItem>
    </xsl:template>
    
    <xsl:template match="docbook:link">
        <xsl:variable name="href">
             <xsl:choose>
                <xsl:when test="not(@xlink:type) or @xlink:type = ''"><xsl:value-of select="@xlink:href"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="cdmresolver:resolve(@xlink:type, @xlink:href)"/></xsl:otherwise>
             </xsl:choose>
        </xsl:variable>
             
        <webLink>
           <href><xsl:value-of select="$href"/></href>
           <linkName><xsl:apply-templates/></linkName>
        </webLink>
    </xsl:template>
    
    <xsl:template match="docbook:mediaobject">
        <xsl:apply-templates select="docbook:*"/>
    </xsl:template>
    
    <xsl:template match="docbook:mediaobject/docbook:alt"/>
    <xsl:template match="docbook:mediaobject/docbook:caption"/>
    
    <xsl:template match="docbook:imageobject">
        <picture>
            <weblink>
                <xsl:if test="../docbook:alt != ''">
                    <linkName><xsl:value-of select="../docbook:alt"/></linkName>
                </xsl:if>
                <href><xsl:value-of select="cdmresolver:resolveImage(docbook:imagedata/@type, docbook:imagedata/@fileref, substring-before(docbook:imagedata/@depth, 'px'), substring-before(docbook:imagedata/@width, 'px'))"/></href>
            </weblink>
            <extension>
            	 <ametys-cdm:width><xsl:value-of select="docbook:imagedata/@width"/></ametys-cdm:width>
            	 <ametys-cdm:height><xsl:value-of select="docbook:imagedata/@depth"/></ametys-cdm:height>
            </extension>
        </picture>
    </xsl:template>
    
    <xsl:template match="docbook:abbrev">
        <xhtml:abbr title="{@title}"><xsl:apply-templates/></xhtml:abbr>
    </xsl:template>
    
    <xsl:template match="docbook:acronym">
        <xhtml:acronym title="{@title}"><xsl:apply-templates/></xhtml:acronym>
    </xsl:template>
    
    <xsl:template match="docbook:quote">
        <xhtml:cite><xsl:apply-templates/></xhtml:cite>
    </xsl:template>
    
    <xsl:template match="docbook:foreignphrase">
        <xhtml:span lang="{@xml:lang}" class="language"><xsl:apply-templates/></xhtml:span>
    </xsl:template>
</xsl:stylesheet>
