/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.oai;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.xml.sax.SAXException;

import org.ametys.odf.cdmfr.ExportCDMfrManager;
import org.ametys.odf.program.Program;

/**
 * Generator for the <code>ListRecords</code> verb.
 */
public class ListRecordsGenerator extends ListIdentifiersGenerator
{
    private ExportCDMfrManager _exportCDMfrManager;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _exportCDMfrManager = (ExportCDMfrManager) serviceManager.lookup(ExportCDMfrManager.ROLE);
    }
    
    @Override
    protected String getTagName()
    {
        return "ListRecords";
    }
    
    /**
     * Generate the program information.
     * @param program the program
     * @throws SAXException if an error occurred while SAXing
     */
    @Override
    protected void saxProgram(Program program) throws SAXException
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        String metadataPrefix = request.getParameter("metadataPrefix");
        
        RecordHelper.saxProgram(program, contentHandler, metadataPrefix, _exportCDMfrManager);
    }
}
