/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.schedulable;

import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

import org.apache.avalon.framework.activity.Initializable;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

import org.ametys.cms.schedule.AbstractDeleteFilesSchedulable;
import org.ametys.plugins.core.schedule.Scheduler;
import org.ametys.runtime.util.AmetysHomeHelper;

/**
 * Schedulable to clean educational booklet generated files.
 */
public class DeleteEducationalBookletSchedulable extends AbstractDeleteFilesSchedulable implements Initializable
{
    /** Parameter for workspace */
    public static final String LIFETIME_KEY = "lifetime";
    
    private static final String __JOBDATAMAP_LIFETIME_KEY = Scheduler.PARAM_VALUES_PREFIX + LIFETIME_KEY;

    private Path _rootPath;
    
    @Override
    public void initialize() throws Exception
    {
        _rootPath = AmetysHomeHelper.getAmetysHomeData().toPath().resolve(EducationalBookletSchedulable.EDUCATIONAL_BOOKLET_DIR_NAME);
    }
    
    @Override
    protected DeleteFilesConfiguration _getConfiguration(JobExecutionContext context)
    {
        DeleteFilesConfiguration configuration = new DeleteFilesConfiguration(_rootPath);
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        long lifetime = jobDataMap.getLong(__JOBDATAMAP_LIFETIME_KEY);
        configuration.setAgeLimit(Instant.now().minus(lifetime, ChronoUnit.DAYS));
        return configuration;
    }
}
