/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.workflow.copy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.cms.workflow.copy.CreateContentByCopyFunction;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.coursepart.CoursePartFactory;
import org.ametys.odf.workflow.CreateCoursePartFunction;
import org.ametys.plugins.repository.data.holder.values.SynchronizableValue;
import org.ametys.plugins.repository.data.holder.values.SynchronizableValue.Mode;
import org.ametys.plugins.repository.jcr.NameHelper.NameComputationMode;
import org.ametys.runtime.i18n.I18nizableText;

import com.opensymphony.workflow.WorkflowException;

/**
 * OSWorkflow function to create a course part by copy of another
 */
public class CreateCoursePartByCopyFunction extends AbstractCreateODFContentByCopyFunction
{
    /** Constant for storing the course holder */
    public static final String COURSE_HOLDER_KEY = "$courseHolder";
    
    @Override
    protected void _populateAdditionalData(Map transientVars, ModifiableContent content) throws WorkflowException
    {
        super._populateAdditionalData(transientVars, content);
        
        // Generate new code
        content.setValue(CoursePart.CODE, org.ametys.core.util.StringUtils.generateKey().toUpperCase());
        
        // copy catalog
        // FIXME remove as soon as the canWrite returns really true at creation
        content.setValue(CoursePart.CATALOG, getBaseContentForCopy(transientVars).getValue(ProgramItem.CATALOG));
        
        // Add the course holder from the copy map
        @SuppressWarnings("unchecked")
        Map<String, Object> copyMap = (Map<String, Object>) transientVars.get(CreateContentByCopyFunction.COPY_MAP_KEY);
        if (copyMap.containsKey(COURSE_HOLDER_KEY))
        {
            content.setValue(CoursePart.COURSE_HOLDER, copyMap.get(COURSE_HOLDER_KEY));
        }
    }
    
    @Override
    protected Map<String, Object> getAdditionalCopyMap(Map transientVars, Content baseContent, String viewName, String fallbackViewName)
    {
        Map<String, Object> additionalCopyMap = new HashMap<>();
        additionalCopyMap.put(CoursePart.CATALOG, null);
        
        // Do the same as ProgramItem copy except the title is always kept
        
        return additionalCopyMap;
    }
    
    @Override
    protected String _getContentNamePrefix()
    {
        return CreateCoursePartFunction.CONTENT_NAME_PREFIX;
    }
    
    @Override
    protected String _getObjectType(Map transientVars, Map args)
    {
        return CoursePartFactory.COURSE_PART_NODETYPE;
    }
    
    @Override
    protected NameComputationMode _getDefaultNameComputationMode()
    {
        return NameComputationMode.GENERATED_KEY;
    }
    
    @Override
    protected Content _getParent(Map transientVars)
    {
        return null;
    }

    @Override
    protected boolean _isCompatibleParent(Content parent)
    {
        return parent instanceof Course;
    }

    @Override
    protected String _getParentAttributeName(Content parent)
    {
        return CoursePart.PARENT_COURSES;
    }

    @Override
    protected SynchronizableValue _buildParentSynchronizableValue(Content parent)
    {
        SynchronizableValue value = new SynchronizableValue(List.of(parent.getId()));
        value.setMode(Mode.APPEND);
        return value;
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf", "PLUGINS_ODF_CREATE_COURSE_PART_BY_COPY_FUNCTION_LABEL");
    }
}
