<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:ametys="org.ametys.cms.transformation.xslt.AmetysXSLTHelper"
                              xmlns:exsl="http://exslt.org/common"
                              xmlns:lom="http://ltsc.ieee.org/xsd/LOM"
                              extension-element-prefixes="exsl">

	<xsl:import href="course.xsl"/>
	<xsl:import href="plugin:cms://stylesheets/helper/html-hierarchy.xsl"/>
	
	<xsl:variable name="uri-prefix" select="ametys:uriPrefix()"/>
	 
	<xsl:variable name="common-content-css-class-name">course view-main</xsl:variable>     
	
	<xsl:template name="common-content-body-content">
        <xsl:variable name="raw-is-title-visible">
            <xsl:call-template name="common-content-body-title-content"/>
        </xsl:variable>
        <xsl:variable name="truelevel">
            <xsl:choose>
                <xsl:when test="string-length($raw-is-title-visible) &gt; 0">2</xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable> 
        
        <div class="col-content">
            <xsl:call-template name="col-content">
                <xsl:with-param name="truelevel" select="$truelevel"/>
            </xsl:call-template>
        </div>         
        <div class="col-right">
            <xsl:call-template name="right-content">
                <xsl:with-param name="truelevel" select="$truelevel"/>
            </xsl:call-template>
        </div>     
        <div class="col-end"/>        
    </xsl:template>       
	
	<!-- + 
	     | TAB 1 : Presentation 
	     + -->
	<xsl:template name="col-content">
        <xsl:param name="truelevel"/>
    
			<!-- Présentation -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/description"/>
                <xsl:with-param name="level" select="$truelevel"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_COURSE_PRESENTATION'"/>
            </xsl:call-template>            

			<!-- Objectifs -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/objectives"/>
                <xsl:with-param name="level" select="$truelevel"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_COURSE_OBJECTIVES'"/>
            </xsl:call-template>            
            
            <!-- Pré requis nécessaires -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/neededPrerequisite"/>
                <xsl:with-param name="level" select="$truelevel"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_COURSE_NEEDED_PREREQUISITE'"/>
            </xsl:call-template>            
            
            <!-- Programme -->
           	<xsl:if test="courseList">
            	<xsl:element name="h{$truelevel}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_ORGANISATION"/></xsl:element>
            	<xsl:apply-templates select="courseList"/>
            </xsl:if>
            
            <!-- Volumes horaire -->
            <xsl:if test="coursePart">
                <xsl:element name="h{$truelevel + 1}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_HOURS"/></xsl:element>
                <xsl:call-template name="courseParts"/>
            </xsl:if>
			
			<!-- Competences visees -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/skills"/>
                <xsl:with-param name="level" select="$truelevel"/>
                <xsl:with-param name="title" select="'plugin.odf:PLUGINS_ODF_COURSE_SKILLS'"/>
            </xsl:call-template>  
			
			<!-- Examens -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/formOfAssessment"/>
                <xsl:with-param name="level" select="$truelevel"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_COURSE_FORM_OF_ASSESSMENT'"/>
            </xsl:call-template>            
                        
            <!-- Syllabus -->
             <xsl:call-template name="common-content-richtext-field">
                 <xsl:with-param name="value" select="metadata/syllabus"/>
                 <xsl:with-param name="level" select="$truelevel"/>
                 <xsl:with-param name="title" select="'plugin.odf:CONTENT_COURSE_SYLLABUS'"/>
             </xsl:call-template>
            
            <!-- Bibliographie -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/bibliography"/>
                <xsl:with-param name="level" select="$truelevel"/>
                <xsl:with-param name="title" select="'plugin.odf:PLUGINS_ODF_COURSE_BIBLIO'"/>
            </xsl:call-template> 
                        
            <!-- Ressources LOM -->
            <xsl:call-template name="lom-resources">
        		<xsl:with-param name="truelevel" select="$truelevel"/>
        	</xsl:call-template>
        
            <!-- Informations supplémentaires -->
            <xsl:call-template name="common-content-richtext-field">
                <xsl:with-param name="value" select="metadata/additionalInformations"/>
                <xsl:with-param name="level" select="$truelevel"/>
                <xsl:with-param name="title" select="'plugin.odf:CONTENT_COURSE_ADDITIONAL_INFORMATIONS'"/>
            </xsl:call-template> 
            
            <!-- Diplômes intégrant cette UE -->
            <xsl:call-template name="ref-programs">
            	<xsl:with-param name="level" select="$truelevel"/>
            </xsl:call-template>
	</xsl:template>
	
    <xsl:template name="courseParts">
        <ul class="custom">
            <xsl:for-each select="coursePart">
                <xsl:if test="count(preceding-sibling::coursePart[nature/@id = current()/nature/@id]) = 0">
                    <li><xsl:value-of select="nature/@title"/> : <xsl:value-of select="sum(../coursePart[nature/@id = current()/nature/@id]/nbHours)"/>h</li>
                </xsl:if>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
	<xsl:template name="ref-programs">
		<xsl:param name="level"/>
		
        <xsl:if test="refProgram">
        	<xsl:element name="h{$level + 2}"><i18n:text i18n:key="CONTENT_COURSE_REF_PROGRAMS" i18n:catalogue="plugin.odf"/></xsl:element>
        	<ul>
	         	<xsl:for-each select="refProgram">
	         		<li><a href="{resolver:resolve('odf', @id)}"><xsl:value-of select="."/></a></li>
	         	</xsl:for-each>
        	</ul>
        </xsl:if>
	</xsl:template>
	
    <!-- +
         | RIGHT CONTENT
         + -->    
    <xsl:template name="right-content">
        <xsl:param name="truelevel"/>
    
        <xsl:call-template name="brief">
            <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
        
        <xsl:call-template name="foreignStudents">
            <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
        
        <xsl:call-template name="contacts">
            <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
        
        <xsl:call-template name="places">
            <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
        
        <xsl:call-template name="more-info">
            <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
        
        <!-- Blocs de compétences requis -->
        <xsl:call-template name="requiredSkills" ><xsl:with-param name="trueLevel" select="$truelevel"/></xsl:call-template>
         
        <!-- Blocs de compétences acquis -->
        <xsl:call-template name="acquiredSkills" ><xsl:with-param name="trueLevel" select="$truelevel"/></xsl:call-template>    
        
    </xsl:template>    
    
    <!-- Blocs de compétences requis -->
    <xsl:template name="requiredSkills">
        <xsl:param name="trueLevel"/>
        
        <xsl:if test="metadata/requiredSkills">
             <div class="bloc required-skills">
                 <xsl:element name="h{$trueLevel}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="PLUGINS_ODF_REQUIRED_SKILLS_LABEL"/></xsl:element>
                 <ul class="custom">
                    <xsl:for-each select="metadata/requiredSkills">
                        <li><xsl:value-of select="@title" /></li>            
                    </xsl:for-each>
                 </ul>
             </div>
         </xsl:if>
    </xsl:template>
    
    <!-- Blocs de compétences acquis -->
    <xsl:template name="acquiredSkills">
        <xsl:param name="trueLevel"/>
        
        <xsl:if test="count(metadata/acquiredSkills/entry) > 0">
             <div class="bloc acquired-skills">
                 <xsl:element name="h{$trueLevel}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="PLUGINS_ODF_ACQUIRED_SKILLS_LABEL"/></xsl:element>
                 <xsl:for-each select="metadata/acquiredSkills/entry">
                      <p><span class="element-name"><xsl:value-of select="skillSet/@title" /></span></p>
                      <xsl:if test="count(skills/entry) > 0">
                          <ul class="custom">
                               <xsl:for-each select="skills/entry">
                                <li><xsl:value-of select="skill/@title" /></li>            
                              </xsl:for-each>
                          </ul>
                      </xsl:if>
                 </xsl:for-each>
             </div>    
         </xsl:if>
    </xsl:template>
        
    <!-- +
         | RIGHT CONTENT : En bref
         + -->
    <xsl:template name="brief">
        <xsl:param name="truelevel"/>
    
        <div class="bloc brief">
            <xsl:element name="h{$truelevel}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_BRIEF"/></xsl:element>
            
            <!-- Nombre de crédits ECTS -->
            <xsl:if test="normalize-space(metadata/ects) != ''">
    			<p class="ects">
		            <span class="element-name">
						<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_ECTS"/>
    				</span>
					<xsl:text> </xsl:text>
   					<span class="element-value"><xsl:value-of select="metadata/ects"/></span>
    			</p>
            </xsl:if>
            
            <!-- Effectif -->
            
            <xsl:if test="normalize-space(metadata/numberOfStudents) != ''">
                <p class="number-students">
                	<span class="element-name">
						<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_MAX_NUMBER_OF_STUDENTS"/>
					</span>
					<xsl:text> </xsl:text>
					<span class="element-value"><xsl:value-of select="metadata/numberOfStudents"/></span>
                </p>
            </xsl:if>
            
            <!-- Nombre d'heure -->
            <xsl:if test="normalize-space(metadata/nbHours) != ''">
            	<p class="hours">
                	<span class="element-name">
						<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_NB_HOURS"/>
					</span>
					<xsl:text> </xsl:text>
					<span class="element-value"><xsl:value-of select="metadata/nbHours"/></span>
                </p>
            </xsl:if>
            
            <!-- Niveau d'étude -->            
            <xsl:if test="metadata/level">
            	<p class="level">
                	<span class="element-name">
						<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_LEVEL"/>
					</span>
					<xsl:text> </xsl:text>
					<span class="element-value"><xsl:value-of select="metadata/level/@title"/></span>
                </p>
            </xsl:if>
        
            <!-- Periode de l'année -->
            <xsl:if test="metadata/teachingTerm">
            	<p class="teaching-term">
                	<span class="element-name">
						<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_TEACHING_TERM"/>
					</span>
					<br/>
					<span class="element-value"><xsl:value-of select="metadata/teachingTerm/@title"/></span>
                </p>
            </xsl:if>
                        
            <!-- Plage horaire -->                        
            <xsl:if test="metadata/timeSlot">
                <p class="time-slot">
                	<span class="element-name">
						<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_TIME_SLOT"/>
					</span>
					<br/>
					<span class="element-value"><xsl:value-of select="metadata/timeSlot/@title"/></span>
                </p>             
            </xsl:if>                        
                
            <!-- Méthode d'enseignement -->
            <xsl:if test="metadata/formofteachingMethod">
            	<p class="teaching-form">
                	<span class="element-name">
						<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_FORM_OF_TEACHING_METHOD"/>
					</span>
					<br/>
					<span class="element-value"><xsl:value-of select="metadata/formofteachingMethod/@title"/></span>
                </p> 
            </xsl:if>            
            
            <!-- Forme d'enseignement -->
            <xsl:if test="metadata/teachingActivity">
            	<p class="teaching-activity">
                	<span class="element-name">
						<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_TEACHING_ACTIVITY"/>
					</span>
					<br/>
					<span class="element-value"><xsl:value-of select="metadata/teachingActivity/@title"/></span>
                </p> 
            </xsl:if>
            
            <!-- Type de formation -->
			<xsl:if test="metadata/formofteachingOrg">
				<p class="teaching-org">
					<span class="element-name">
						<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_FORM_OF_TEACHING_ORG"/>
					</span>
					<ul>
		         		<xsl:for-each select="metadata/formofteachingOrg">
		         			<li><xsl:value-of select="@title"/></li>
		         		</xsl:for-each>
		         	</ul>
				</p>
			</xsl:if>
         
            <!-- Langue d'enseignement -->
            <xsl:if test="normalize-space(metadata/teachingLanguage) != ''">
            	<p class="teaching-lang">
                	<span class="element-name">
						<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_TEACHING_LANGUAGE"/>
					</span>
					<ul>
						<xsl:for-each select="metadata/teachingLanguage">
							<li><xsl:value-of select="@title"/></li>
						</xsl:for-each>
					</ul>
                </p> 
            </xsl:if>            
            
            <!-- Date de début des cours -->            
            <xsl:if test="normalize-space(metadata/startDate) != ''">
            	<p class="start-date">
                	<span class="element-name">
						<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_START_DATE"/>
					</span>
					<br/>
					<span class="element-value"><i18n:date value="{metadata/startDate}" src-pattern="yyyy-MM-dd'T'HH:mm" pattern="long"/></span>
                </p> 
            </xsl:if>            
        </div>
    </xsl:template>

	<!-- +
	     | RIGHT CONTENT : foreignStudents
	     + -->
	<xsl:template name="foreignStudents">
        <xsl:param name="truelevel"/>
		
		<xsl:if test="normalize-space(metadata/openToExchangeStudents) = 'true'">
			<div class="bloc">
				<xsl:element name="h{$truelevel}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_FOREIGN_STUDENTS"/></xsl:element>
				
				<strong><i18n:text i18n:key="PLUGINS_ODF_COURSE_EXCHANGE_STUDENTS_OPEN" i18n:catalogue="plugin.odf"/></strong>
		        <br/>
			</div>	
		</xsl:if>
	</xsl:template>  
  	
	<!-- +
	     | RIGHT CONTENT : Contacts
	     + -->
	<xsl:template name="contacts">
        <xsl:param name="truelevel"/>
    
    	<xsl:if test="metadata/contacts/entry/persons or metadata/orgUnit">
			<div class="bloc contacts">
				<xsl:element name="h{$truelevel}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_CONTACT"/></xsl:element>
				
				<xsl:if test="metadata/orgUnit">
					<xsl:element name="h{$truelevel + 1}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_ORGUNIT"/></xsl:element>
					<xsl:for-each select="metadata/orgUnit">
                        <xsl:variable name="orgUnitId" select="@id"/>
                        <xsl:apply-templates select="//content/orgunits/content[@id = $orgUnitId]/html/body/node()" mode="move-hierarchy">
                            <xsl:with-param name="level" select="$truelevel + 2"/>
                        </xsl:apply-templates>  
					</xsl:for-each>
				</xsl:if>	
                
                <xsl:for-each select="metadata/contacts/entry">
                    <xsl:choose>
                        <xsl:when test="normalize-space(role/@title) != ''">
                            <xsl:element name="h{$truelevel + 1}"><xsl:value-of select="role/@title"/></xsl:element>
                            <xsl:for-each select="persons">
                                <xsl:variable name="personId" select="@id"/>
                                <xsl:apply-templates select="//content/persons/content[@id = $personId]/html/body/node()" mode="move-hierarchy">
                                    <xsl:with-param name="level" select="$truelevel + 2"/>
                                </xsl:apply-templates>
                            </xsl:for-each>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:for-each select="persons">
                                <xsl:variable name="personId" select="@id"/>
                                <xsl:apply-templates select="//content/persons/content[@id = $personId]/html/body/node()" mode="move-hierarchy">
                                    <xsl:with-param name="level" select="$truelevel + 1"/>
                                </xsl:apply-templates>
                            </xsl:for-each>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
			</div>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="places">
        <xsl:param name="truelevel"/>
		
		<xsl:if test="metadata/teachingLocation">
			<div class="bloc places">
				<xsl:element name="h{$truelevel}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_PLACE"/></xsl:element>
				
				<ul>
					<xsl:for-each select="metadata/teachingLocation">
						<li><xsl:value-of select="@title"/></li>
					</xsl:for-each>
				</ul>
			</div>	
		</xsl:if>
        
        <xsl:if test="metadata/campus">
            <div class="bloc campus">
                <xsl:element name="h{$truelevel}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_CAMPUS"/></xsl:element>
                
                <ul>
                    <xsl:for-each select="metadata/campus">
                        <li><xsl:value-of select="@title"/></li>
                    </xsl:for-each>
                </ul>
            </div>  
        </xsl:if>
	</xsl:template>
	
    <!-- +
         | RIGHT CONTENT : En savoir plus
         + -->
    <xsl:template name="more-info">
        <xsl:param name="truelevel"/>
    
        <xsl:if test="normalize-space(metadata/webLinkUrl) != ''">
            <div class="bloc sitec">
                <xsl:element name="h{$truelevel}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_WEB_LINK_TITLE"/></xsl:element>
                <p>
                    <a href="{metadata/webLinkUrl}">
                        <xsl:choose>
                            <xsl:when test="normalize-space(metadata/webLinkLabel) != ''"><xsl:value-of select="metadata/webLinkLabel"/></xsl:when>
                            <xsl:otherwise><xsl:value-of select="metadata/webLinkUrl"/></xsl:otherwise>
                        </xsl:choose>                
                    </a>                        
                </p>
            </div>
        </xsl:if>   
    </xsl:template>
    
    <!-- +
         | RIGHT CONTENT : Ressources LOM
         + -->
    <xsl:template name="lom-resources">
        <xsl:param name="truelevel"/>
    
        <xsl:param name="truelevel"/>
    
    	<xsl:if test="metadata/lomSheets/entry[linkUrl != '']">
    		<div class="lom-resources">
            	<xsl:element name="h{$truelevel}"><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_RESOURCES"/></xsl:element>
	    		
	    		<xsl:for-each select="metadata/lomSheets/entry">
		    		<xsl:variable name="lomSheet" select="exsl:node-set(document(linkUrl))"/>
		    		
		    		<div class="lom-resource">
			    		<xsl:variable name="lomResources" select="exsl:node-set($lomSheet/lom:lom/lom:technical/lom:location)"/>
			    		
		    			<xsl:choose>
		    				<xsl:when test="count($lomResources) = 0">
		    					<span class="element-name">
		    						<xsl:value-of select="linkLabel"/>
		    						<xsl:if test="count($lomSheet/lom:lom) = 0"> <i>(<i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_RESOURCES_UNAVAILABLE_SHEET"/>)</i></xsl:if>
		    					</span>
		    				</xsl:when>
		    				<xsl:when test="count($lomResources) = 1">
		    					<a href="{$lomResources}" target="_blank">
		    						<span class="element-name"><xsl:value-of select="linkLabel"/></span>
		    					</a>
		    				</xsl:when>
		    				<xsl:otherwise>
		    					<span class="element-name"><xsl:value-of select="linkLabel"/></span><br/>
		    					<span class="element-value">
		    						<xsl:for-each select="lomResources">
				    					<li><a target="_blank" href="{.}"><xsl:value-of select="."/></a></li>
				    				</xsl:for-each>
		    					</span>
		    				</xsl:otherwise>
		    			</xsl:choose>
		    			
		    			<!-- Parent resources -->
		    			<xsl:variable name="lomParents" select="exsl:node-set($lomSheet/lom:lom/lom:relation[lom:kind/lom:value = 'ispartof'])"/>
		    			<xsl:if test="count($lomParents) > 0">
		    				<div class="subsheet">
			    				<span><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_RESOURCES_ISPARTOF"/></span><br/>
			    				<ul>
			    					<xsl:for-each select="$lomParents">
			    						<li><a target="_blank" href="{lom:resource/lom:identifier/lom:entry}"><xsl:value-of select="lom:resource/lom:description/lom:string"/></a></li>
		    						</xsl:for-each>
		    					</ul>
	    					</div>
	   					</xsl:if>
	   					
	   					<!-- Children resources -->
	   					<xsl:variable name="lomChildren" select="exsl:node-set($lomSheet/lom:lom/lom:relation[lom:kind/lom:value = 'haspart'])"/>
	   					<xsl:if test="count($lomChildren) > 0">
		    				<div class="subsheet">
			    				<span><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSE_RESOURCES_HASPART"/></span><br/>
			    				<ul>
			    					<xsl:for-each select="$lomChildren">
				    					<li><a target="_blank" href="{lom:resource/lom:identifier/lom:entry}"><xsl:value-of select="lom:resource/lom:description/lom:string"/></a></li>
			    					</xsl:for-each>
			    				</ul>
		    				</div>
		    			</xsl:if>
			    	</div>
		    	</xsl:for-each>
		    </div>
    	</xsl:if>
    </xsl:template>
	
	<xsl:template match="courseList">
		<p>
			<strong><xsl:value-of select="@title"/></strong>
			<xsl:if test="@ects != ''"> (<xsl:value-of select="@ects"/><xsl:text> </xsl:text><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSELIST_ECTS"/>)</xsl:if>
			<xsl:choose>
				<xsl:when test="@type = 'CHOICE'">
                    <br/>
                    <xsl:value-of select="@min"/><xsl:text> </xsl:text>
                    <xsl:if test="@max > 0 and @min != @max">
                        <i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSELIST_CHOICE_TO"/>
                        <xsl:text> </xsl:text>
                        <xsl:value-of select="@max"/>
                        <xsl:text> </xsl:text>
                    </xsl:if>
                    <xsl:text> </xsl:text>
                    <i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSELIST_CHOICE"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="count(course)"/>
				</xsl:when>
				<xsl:when test="@type = 'MANDATORY'"><br/><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSELIST_MANDATORY"/>
				</xsl:when>
				<xsl:when test="@type = 'OPTIONAL'"><br/><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSELIST_OPTIONAL"/>
				</xsl:when>
			</xsl:choose>
		</p>
		
		<xsl:if test="course">
			<ul class="custom">
				<xsl:apply-templates select="course"/>
			</ul>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="course">
		<li>
        	<a href="{resolver:resolve('odf', concat(@id, ';', /view/content/@id))}">
        		<xsl:value-of select="@title"/>
        		<xsl:if test="metadata/ects != '' and metadata/ects != '0'"><xsl:text> (</xsl:text><xsl:value-of select="metadata/ects"/><xsl:text> </xsl:text><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_COURSELIST_ECTS"/><xsl:text>)</xsl:text></xsl:if>
        	</a>
        </li>
	</xsl:template>
		
</xsl:stylesheet>