/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf;

import com.opensymphony.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.AbstractContentWorkflowComponent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.util.JSONUtils;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.person.Person;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.odf.workflow.AbstractCreateODFContentFunction;
import org.ametys.odf.workflow.CreateCoursePartFunction;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ODFContentHelper
implements Serviceable,
Component {
    public static final String ROLE = ODFContentHelper.class.getName();
    public static final String DEFAULT_ORG_UNIT_CODE_UAI = "UAI-DEF-1234";
    public static final String DEFAULT_PROGRAM_DOMAIN = "ALL";
    public static final String DEFAULT_PROGRAM_DEGREE = "XA";
    public static final String DEFAULT_CONTAINER_PERIOD = "an";
    public static final String DEFAULT_CONTAINER_NATURE = "annee";
    public static final CourseList.ChoiceType DEFAULT_COURSE_LIST_CHOICE_TYPE = CourseList.ChoiceType.MANDATORY;
    public static final String DEFAULT_COURSE_NATURE = "UE";
    public static final String DEFAULT_COURSE_PART_NATURE = "TD";
    public static final Double DEFAULT_COURSE_PART_NB_HOURS = 1.0;
    public static final String PROGRAM_PART_TYPE = "programPartType";
    protected ContentWorkflowHelper _contentWorkflowHelper;
    protected OdfReferenceTableHelper _odfReferenceTableHelper;
    protected JSONUtils _jsonUtils;
    private Map<String, String> _programDomains = new HashMap<String, String>();
    private Map<String, String> _programDegrees = new HashMap<String, String>();
    private Map<String, String> _containerPeriods = new HashMap<String, String>();
    private Map<String, String> _containerNatures = new HashMap<String, String>();
    private Map<String, String> _courseNatures = new HashMap<String, String>();
    private Map<String, String> _coursePartNatures = new HashMap<String, String>();

    public void service(ServiceManager manager) throws ServiceException {
        this._contentWorkflowHelper = (ContentWorkflowHelper)manager.lookup(ContentWorkflowHelper.ROLE);
        this._odfReferenceTableHelper = (OdfReferenceTableHelper)manager.lookup(OdfReferenceTableHelper.ROLE);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
    }

    private List<String> _getOrgUnitIds(Map<String, Object> data, String key) {
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        List orgUnits = (List)data.get(key);
        for (Object orgUnit : orgUnits) {
            String orgUnitId = orgUnit instanceof OrgUnit ? ((OrgUnit)orgUnit).getId() : (String)orgUnit;
            orgUnitIds.add(orgUnitId);
        }
        return orgUnitIds;
    }

    private List<String> _getAbstractProgramPartChildren(Map<String, Object> data, String contentTitle, ProgramPartType defaultProgramPartType, String defaultCatalog, List<String> defaultOrgUnits) throws AmetysRepositoryException, WorkflowException {
        ArrayList<String> children = new ArrayList<String>();
        List dataChildren = (List)data.get("childProgramParts");
        for (Object child : dataChildren) {
            if (child instanceof String) {
                children.add((String)child);
                continue;
            }
            if (child instanceof Content) {
                children.add(((Content)child).getId());
                continue;
            }
            Map dataChild = (Map)child;
            ProgramPartType programPartType = this._getProgramPartType(dataChild, contentTitle, defaultProgramPartType);
            if (ProgramPartType.SUB_PROGRAM.equals((Object)programPartType)) {
                SubProgram subProgram = (SubProgram)((SubProgramBuilder)((SubProgramBuilder)new SubProgramBuilder().withDefaultCatalog(defaultCatalog)).withDefaultOrgUnits(defaultOrgUnits).fromJavaMap(dataChild)).build();
                children.add(subProgram.getId());
                continue;
            }
            if (ProgramPartType.CONTAINER.equals((Object)programPartType)) {
                Container container = (Container)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withDefaultCatalog(defaultCatalog)).withDefaultOrgUnits(defaultOrgUnits).fromJavaMap(dataChild)).build();
                children.add(container.getId());
                continue;
            }
            if (ProgramPartType.COURSE_LIST.equals((Object)programPartType)) {
                CourseList courseList = (CourseList)((CourseListBuilder)((CourseListBuilder)new CourseListBuilder().withDefaultCatalog(defaultCatalog)).withDefaultOrgUnits(defaultOrgUnits).fromJavaMap(dataChild)).build();
                children.add(courseList.getId());
                continue;
            }
            throw new IllegalArgumentException("the 'programPartType' in the given child data of the content '" + contentTitle + "' is invalid. The given value is '" + programPartType + "' but should be one of the following: '" + ProgramPartType.SUB_PROGRAM + "', '" + ProgramPartType.CONTAINER + "' or '" + ProgramPartType.COURSE_LIST + "'.");
        }
        return children;
    }

    private ProgramPartType _getProgramPartType(Map<String, Object> data, String contentTitle, ProgramPartType defaultProgramPartType) {
        if (data.containsKey(PROGRAM_PART_TYPE)) {
            if (data.get(PROGRAM_PART_TYPE) instanceof String) {
                return ProgramPartType.valueOf((String)data.get(PROGRAM_PART_TYPE));
            }
            if (data.get(PROGRAM_PART_TYPE) instanceof ProgramPartType) {
                return (ProgramPartType)((Object)data.get(PROGRAM_PART_TYPE));
            }
            throw new IllegalArgumentException("the 'programPartType' in the given data of the content '" + contentTitle + "' is invalid.");
        }
        return defaultProgramPartType;
    }

    public <T extends WorkflowAwareContent> T createContent(String title, String contentType, String workflowName, Map<String, Object> values, Map<String, Object> inputs) throws AmetysRepositoryException, WorkflowException {
        Map results = this._contentWorkflowHelper.createContent(workflowName, 1, title, title, new String[]{contentType}, null, "fr", inputs);
        WorkflowAwareContent content = (WorkflowAwareContent)results.get(Content.class.getName());
        this.editContent(content, values);
        return (T)content;
    }

    public void editContent(WorkflowAwareContent content, Map<String, Object> values) throws AmetysRepositoryException, WorkflowException {
        this._contentWorkflowHelper.editContent(content, values, 2);
    }

    public void validateContents(WorkflowAwareContent ... contents) throws AmetysRepositoryException, WorkflowException {
        for (WorkflowAwareContent content : contents) {
            HashMap<String, Object> inputs = new HashMap<String, Object>();
            inputs.put(AbstractContentWorkflowComponent.CONTENT_KEY, content);
            inputs.put(AbstractWorkflowComponent.RESULT_MAP_KEY, Map.of());
            this._contentWorkflowHelper.doAction(content, 4, inputs);
        }
    }

    public static enum ProgramPartType {
        SUB_PROGRAM,
        CONTAINER,
        COURSE_LIST;

    }

    public class SubProgramBuilder
    extends AbstractODFContentBuidler<SubProgram, SubProgramBuilder> {
        protected List<String> _defaultOrgUnitIds;

        public SubProgramBuilder() {
            this._defaultOrgUnitIds = new ArrayList<String>();
        }

        @Override
        protected Map<String, Object> _getContentValues(Map<String, Object> data) throws AmetysRepositoryException, WorkflowException {
            HashMap<String, Object> contentValues = new HashMap<String, Object>();
            List<String> orgUnitIds = data.containsKey("orgUnit") ? ODFContentHelper.this._getOrgUnitIds(data, "orgUnit") : this._defaultOrgUnitIds;
            contentValues.put("orgUnit", orgUnitIds);
            block10: for (Map.Entry<String, Object> entry : data.entrySet()) {
                switch (entry.getKey()) {
                    case "orgUnit": {
                        continue block10;
                    }
                    case "programPartType": {
                        continue block10;
                    }
                    case "childProgramParts": {
                        List<String> childrenIds = ODFContentHelper.this._getAbstractProgramPartChildren(data, this._title, ProgramPartType.CONTAINER, this._catalogName, orgUnitIds);
                        contentValues.put("childProgramParts", childrenIds);
                        continue block10;
                    }
                }
                contentValues.put(entry.getKey(), entry.getValue());
            }
            return contentValues;
        }

        public SubProgramBuilder withDefaultOrgUnits(OrgUnit ... defaultOrgUnits) {
            return this.withDefaultOrgUnits(Arrays.stream(defaultOrgUnits).map(SimpleAmetysObject::getId).collect(Collectors.toList()));
        }

        public SubProgramBuilder withDefaultOrgUnits(List<String> defaultOrgUnitIds) {
            this._defaultOrgUnitIds = defaultOrgUnitIds;
            return this;
        }

        @Override
        protected String _getContentType() {
            return "org.ametys.plugins.odf.Content.subProgram";
        }

        @Override
        protected String _getDefaultTitle() {
            return "SubProgram";
        }

        @Override
        protected String _getWorkflowName() {
            return "subprogram";
        }
    }

    public abstract class AbstractODFContentBuidler<T, B extends AbstractODFContentBuidler<T, B>> {
        protected String _title;
        protected String _catalogName;
        protected String _defaultCatalogName;
        protected Map<String, Object> _data = new HashMap<String, Object>();

        public B fromJSON(String data) {
            this._data = ODFContentHelper.this._jsonUtils.convertJsonToMap(data);
            return (B)this;
        }

        public B fromJavaMap(Map<String, Object> data) {
            this._data = data;
            return (B)this;
        }

        public B withDefaultCatalog(String defaultCatalogName) {
            this._defaultCatalogName = defaultCatalogName;
            return (B)this;
        }

        protected Map<String, Object> _getContentValues(Map<String, Object> data) throws AmetysRepositoryException, WorkflowException {
            return data;
        }

        protected Map<String, Object> _getDefaultValues() {
            return Map.of();
        }

        protected abstract String _getDefaultTitle();

        protected abstract String _getContentType();

        protected abstract String _getWorkflowName();

        protected Map<String, Object> _getWorkflowInputs() {
            HashMap<String, Object> inputs = new HashMap<String, Object>();
            if (this._catalogName != null) {
                inputs.put(AbstractCreateODFContentFunction.CONTENT_CATALOG_KEY, this._catalogName);
            }
            return inputs;
        }

        public T build() throws AmetysRepositoryException, WorkflowException {
            this._title = this._data.containsKey("title") ? (String)this._data.get("title") : this._getDefaultTitle();
            this._catalogName = this._data.containsKey("catalog") ? (String)this._data.get("catalog") : this._defaultCatalogName;
            Map<String, Object> filteredData = this._data.keySet().stream().filter(key -> !"title".equals(key)).filter(key -> !"catalog".equals(key)).collect(Collectors.toMap(key -> key, key -> this._data.get(key)));
            Map<String, Object> contentValues = this._getContentValues(filteredData);
            Map<String, Object> defaultValues = this._getDefaultValues();
            for (Map.Entry<String, Object> entry : defaultValues.entrySet()) {
                if (contentValues.containsKey(entry.getKey())) continue;
                contentValues.put(entry.getKey(), entry.getValue());
            }
            return ODFContentHelper.this.createContent(this._title, this._getContentType(), this._getWorkflowName(), contentValues, this._getWorkflowInputs());
        }
    }

    public class ContainerBuilder
    extends AbstractODFContentBuidler<Container, ContainerBuilder> {
        protected List<String> _defaultOrgUnitIds = new ArrayList<String>();

        @Override
        protected Map<String, Object> _getContentValues(Map<String, Object> data) throws AmetysRepositoryException, WorkflowException {
            HashMap<String, Object> contentValues = new HashMap<String, Object>();
            ArrayList<String> defaultOrgUnitIds = new ArrayList<String>();
            if (data.containsKey("orgUnit")) {
                Object orgUnit = data.get("orgUnit");
                String orgUnitId = orgUnit instanceof OrgUnit ? ((OrgUnit)orgUnit).getId() : (String)orgUnit;
                contentValues.put("orgUnit", List.of(orgUnitId));
                defaultOrgUnitIds.add(orgUnitId);
            } else if (!this._defaultOrgUnitIds.isEmpty()) {
                contentValues.put("orgUnit", this._defaultOrgUnitIds);
                defaultOrgUnitIds.addAll(defaultOrgUnitIds);
            }
            block14: for (Map.Entry<String, Object> entry : data.entrySet()) {
                switch (entry.getKey()) {
                    case "orgUnit": {
                        continue block14;
                    }
                    case "programPartType": {
                        continue block14;
                    }
                    case "period": {
                        contentValues.put("period", this._getPeriodContentId((String)entry.getValue()));
                        continue block14;
                    }
                    case "nature": {
                        contentValues.put("nature", this._getNatureContentId((String)entry.getValue()));
                        continue block14;
                    }
                    case "childProgramParts": {
                        List<String> childrenIds = ODFContentHelper.this._getAbstractProgramPartChildren(data, this._title, ProgramPartType.COURSE_LIST, this._catalogName, defaultOrgUnitIds);
                        contentValues.put("childProgramParts", childrenIds);
                        continue block14;
                    }
                }
                contentValues.put(entry.getKey(), entry.getValue());
            }
            return contentValues;
        }

        @Override
        protected Map<String, Object> _getDefaultValues() {
            return Map.of("period", this._getPeriodContentId(ODFContentHelper.DEFAULT_CONTAINER_PERIOD), "nature", this._getNatureContentId(ODFContentHelper.DEFAULT_CONTAINER_NATURE));
        }

        private String _getPeriodContentId(String period) {
            if (!ODFContentHelper.this._containerPeriods.containsKey(period)) {
                ODFContentHelper.this._containerPeriods.put(period, ODFContentHelper.this._odfReferenceTableHelper.getItemFromCode("odf-enumeration.Period", period).getId());
            }
            return ODFContentHelper.this._containerPeriods.get(period);
        }

        private String _getNatureContentId(String nature) {
            if (!ODFContentHelper.this._containerNatures.containsKey(nature)) {
                ODFContentHelper.this._containerNatures.put(nature, ODFContentHelper.this._odfReferenceTableHelper.getItemFromCode("odf-enumeration.ContainerNature", nature).getId());
            }
            return ODFContentHelper.this._containerNatures.get(nature);
        }

        public ContainerBuilder withDefaultOrgUnits(OrgUnit ... defaultOrgUnits) {
            return this.withDefaultOrgUnits(Arrays.stream(defaultOrgUnits).map(SimpleAmetysObject::getId).collect(Collectors.toList()));
        }

        public ContainerBuilder withDefaultOrgUnits(List<String> defaultOrgUnitIds) {
            this._defaultOrgUnitIds = defaultOrgUnitIds;
            return this;
        }

        @Override
        protected String _getContentType() {
            return "org.ametys.plugins.odf.Content.container";
        }

        @Override
        protected String _getDefaultTitle() {
            return "Container";
        }

        @Override
        protected String _getWorkflowName() {
            return "container";
        }
    }

    public class CourseListBuilder
    extends AbstractODFContentBuidler<CourseList, CourseListBuilder> {
        protected List<String> _defaultOrgUnitIds = new ArrayList<String>();

        @Override
        protected Map<String, Object> _getContentValues(Map<String, Object> data) throws AmetysRepositoryException, WorkflowException {
            HashMap<String, Object> contentValues = new HashMap<String, Object>();
            block10: for (Map.Entry<String, Object> entry : data.entrySet()) {
                switch (entry.getKey()) {
                    case "programPartType": {
                        continue block10;
                    }
                    case "choiceType": {
                        String choiceType = data.get("choiceType").toString();
                        contentValues.put("choiceType", choiceType);
                        continue block10;
                    }
                    case "courses": {
                        List<String> childrenIds = this._getChildrenIds(data, this._catalogName, this._defaultOrgUnitIds);
                        contentValues.put("courses", childrenIds);
                        continue block10;
                    }
                }
                contentValues.put(entry.getKey(), entry.getValue());
            }
            return contentValues;
        }

        @Override
        protected Map<String, Object> _getDefaultValues() {
            return Map.of("choiceType", DEFAULT_COURSE_LIST_CHOICE_TYPE.toString());
        }

        private List<String> _getChildrenIds(Map<String, Object> data, String defaultCatalog, List<String> defaultOrgUnitIds) throws AmetysRepositoryException, WorkflowException {
            ArrayList<String> childrenIds = new ArrayList<String>();
            List dataChildren = (List)data.get("courses");
            for (Object child : dataChildren) {
                if (child instanceof String) {
                    childrenIds.add((String)child);
                    continue;
                }
                if (child instanceof Course) {
                    childrenIds.add(((Course)child).getId());
                    continue;
                }
                Map dataChild = (Map)child;
                Course course = (Course)((CourseBuilder)((CourseBuilder)new CourseBuilder().withDefaultCatalog(defaultCatalog)).withDefaultOrgUnits(defaultOrgUnitIds).fromJavaMap(dataChild)).build();
                childrenIds.add(course.getId());
            }
            return childrenIds;
        }

        public CourseListBuilder withDefaultOrgUnits(OrgUnit ... defaultOrgUnits) {
            return this.withDefaultOrgUnits(Arrays.stream(defaultOrgUnits).map(SimpleAmetysObject::getId).collect(Collectors.toList()));
        }

        public CourseListBuilder withDefaultOrgUnits(List<String> defaultOrgUnitIds) {
            this._defaultOrgUnitIds = defaultOrgUnitIds;
            return this;
        }

        @Override
        protected String _getContentType() {
            return "org.ametys.plugins.odf.Content.courseList";
        }

        @Override
        protected String _getDefaultTitle() {
            return "CourseList";
        }

        @Override
        protected String _getWorkflowName() {
            return "courselist";
        }
    }

    public class PersonBuilder
    extends AbstractODFContentBuidler<Person, PersonBuilder> {
        @Override
        protected String _getContentType() {
            return "org.ametys.plugins.odf.Content.person";
        }

        @Override
        protected String _getDefaultTitle() {
            return "Person";
        }

        @Override
        protected String _getWorkflowName() {
            return "person";
        }
    }

    public class ODFTableRefBuilder
    extends AbstractODFContentBuidler<ModifiableContent, ODFTableRefBuilder> {
        private String _contentType;

        @Override
        protected String _getContentType() {
            return this._contentType;
        }

        @Override
        protected String _getDefaultTitle() {
            return "TableRef";
        }

        @Override
        protected String _getWorkflowName() {
            return "reference-table";
        }

        public ODFTableRefBuilder withContentType(String contentType) {
            this._contentType = contentType;
            return this;
        }
    }

    public class CoursePartBuilder
    extends AbstractODFContentBuidler<CoursePart, CoursePartBuilder> {
        protected String _nature;
        protected Double _nbHours;

        @Override
        protected Map<String, Object> _getDefaultValues() {
            return Map.of("nature", this._getNatureContentId(ODFContentHelper.DEFAULT_COURSE_PART_NATURE), "nbHours", DEFAULT_COURSE_PART_NB_HOURS);
        }

        private String _getNatureContentId(String nature) {
            if (!ODFContentHelper.this._coursePartNatures.containsKey(nature)) {
                OdfReferenceTableEntry itemFromCode = ODFContentHelper.this._odfReferenceTableHelper.getItemFromCode("odf-enumeration.EnseignementNature", nature);
                ODFContentHelper.this._coursePartNatures.put(nature, itemFromCode != null ? itemFromCode.getId() : nature);
            }
            return ODFContentHelper.this._coursePartNatures.get(nature);
        }

        @Override
        protected String _getContentType() {
            return "org.ametys.plugins.odf.Content.coursePart";
        }

        @Override
        protected String _getDefaultTitle() {
            return "CoursePart";
        }

        @Override
        protected String _getWorkflowName() {
            return "course-part";
        }

        @Override
        protected Map<String, Object> _getWorkflowInputs() {
            Map<String, Object> inputs = super._getWorkflowInputs();
            Optional.of("courseHolder").map(this._data::get).map(Course.class::cast).map(SimpleAmetysObject::getId).ifPresent(id -> inputs.put(CreateCoursePartFunction.COURSE_HOLDER_KEY, id));
            return inputs;
        }
    }

    public class CourseBuilder
    extends AbstractODFContentBuidler<Course, CourseBuilder> {
        protected List<String> _defaultOrgUnitIds = new ArrayList<String>();

        @Override
        protected Map<String, Object> _getContentValues(Map<String, Object> data) throws AmetysRepositoryException, WorkflowException {
            HashMap<String, Object> contentValues = new HashMap<String, Object>();
            List<String> orgUnitIds = data.containsKey("orgUnit") ? ODFContentHelper.this._getOrgUnitIds(data, "orgUnit") : this._defaultOrgUnitIds;
            contentValues.put("orgUnit", orgUnitIds);
            block12: for (Map.Entry<String, Object> entry : data.entrySet()) {
                switch (entry.getKey()) {
                    case "orgUnit": {
                        continue block12;
                    }
                    case "courseType": {
                        contentValues.put("courseType", this._getNatureContentId((String)entry.getValue()));
                        continue block12;
                    }
                    case "courseLists": {
                        List<String> courseListIds = this._getCourseLists(data, this._catalogName, orgUnitIds);
                        contentValues.put("courseLists", courseListIds);
                        continue block12;
                    }
                    case "courseParts": {
                        List<String> coursePartIds = this._getCourseParts(data, this._catalogName);
                        contentValues.put("courseParts", coursePartIds);
                        continue block12;
                    }
                }
                contentValues.put(entry.getKey(), entry.getValue());
            }
            return contentValues;
        }

        @Override
        protected Map<String, Object> _getDefaultValues() {
            return Map.of("courseType", this._getNatureContentId(ODFContentHelper.DEFAULT_COURSE_NATURE));
        }

        private String _getNatureContentId(String nature) {
            if (!ODFContentHelper.this._courseNatures.containsKey(nature)) {
                ODFContentHelper.this._courseNatures.put(nature, ODFContentHelper.this._odfReferenceTableHelper.getItemFromCode("odf-enumeration.CourseNature", nature).getId());
            }
            return ODFContentHelper.this._courseNatures.get(nature);
        }

        private List<String> _getCourseLists(Map<String, Object> data, String defaultCatalog, List<String> defaultOrgUnitIds) throws AmetysRepositoryException, WorkflowException {
            ArrayList<String> courseListIds = new ArrayList<String>();
            List dataChildren = (List)data.get("courseLists");
            for (Object child : dataChildren) {
                if (child instanceof String) {
                    courseListIds.add((String)child);
                    continue;
                }
                if (child instanceof CourseList) {
                    courseListIds.add(((CourseList)child).getId());
                    continue;
                }
                Map dataChild = (Map)child;
                CourseList courseList = (CourseList)((CourseListBuilder)((CourseListBuilder)new CourseListBuilder().withDefaultCatalog(defaultCatalog)).withDefaultOrgUnits(defaultOrgUnitIds).fromJavaMap(dataChild)).build();
                courseListIds.add(courseList.getId());
            }
            return courseListIds;
        }

        private List<String> _getCourseParts(Map<String, Object> data, String defaultCatalog) throws AmetysRepositoryException, WorkflowException {
            ArrayList<String> coursePartIds = new ArrayList<String>();
            List dataChildren = (List)data.get("courseParts");
            for (Object child : dataChildren) {
                if (child instanceof String) {
                    coursePartIds.add((String)child);
                    continue;
                }
                if (child instanceof CoursePart) {
                    coursePartIds.add(((CoursePart)child).getId());
                    continue;
                }
                Map dataChild = (Map)child;
                CoursePart coursePart = (CoursePart)((CoursePartBuilder)((CoursePartBuilder)new CoursePartBuilder().withDefaultCatalog(defaultCatalog)).fromJavaMap(dataChild)).build();
                coursePartIds.add(coursePart.getId());
            }
            return coursePartIds;
        }

        public CourseBuilder withDefaultOrgUnits(OrgUnit ... defaultOrgUnits) {
            return this.withDefaultOrgUnits(Arrays.stream(defaultOrgUnits).map(SimpleAmetysObject::getId).collect(Collectors.toList()));
        }

        public CourseBuilder withDefaultOrgUnits(List<String> defaultOrgUnitIds) {
            this._defaultOrgUnitIds = defaultOrgUnitIds;
            return this;
        }

        @Override
        protected String _getContentType() {
            return "org.ametys.plugins.odf.Content.course";
        }

        @Override
        protected String _getDefaultTitle() {
            return "Course";
        }

        @Override
        protected String _getWorkflowName() {
            return "course";
        }
    }

    public class ProgramBuilder
    extends AbstractODFContentBuidler<Program, ProgramBuilder> {
        protected List<String> _defaultOrgUnitIds = new ArrayList<String>();

        @Override
        protected Map<String, Object> _getContentValues(Map<String, Object> data) throws AmetysRepositoryException, WorkflowException {
            HashMap<String, Object> contentValues = new HashMap<String, Object>();
            List<String> orgUnitIds = data.containsKey("orgUnit") ? ODFContentHelper.this._getOrgUnitIds(data, "orgUnit") : this._defaultOrgUnitIds;
            contentValues.put("orgUnit", orgUnitIds);
            block12: for (Map.Entry<String, Object> entry : data.entrySet()) {
                switch (entry.getKey()) {
                    case "orgUnit": {
                        continue block12;
                    }
                    case "degree": {
                        contentValues.put("degree", this._getDegreeContentId((String)entry.getValue()));
                        continue block12;
                    }
                    case "domain": {
                        contentValues.put("domain", this._getDomainContentIds((List)entry.getValue()));
                        continue block12;
                    }
                    case "childProgramParts": {
                        List<String> childrenIds = ODFContentHelper.this._getAbstractProgramPartChildren(data, this._title, ProgramPartType.SUB_PROGRAM, this._catalogName, orgUnitIds);
                        contentValues.put("childProgramParts", childrenIds);
                        continue block12;
                    }
                }
                contentValues.put(entry.getKey(), entry.getValue());
            }
            return contentValues;
        }

        @Override
        protected Map<String, Object> _getDefaultValues() {
            return Map.of("degree", this._getDegreeContentId(ODFContentHelper.DEFAULT_PROGRAM_DEGREE), "domain", this._getDomainContentIds(List.of(ODFContentHelper.DEFAULT_PROGRAM_DOMAIN)));
        }

        private String _getDegreeContentId(String degree) {
            if (!ODFContentHelper.this._programDegrees.containsKey(degree)) {
                ODFContentHelper.this._programDegrees.put(degree, ODFContentHelper.this._odfReferenceTableHelper.getItemFromCode("odf-enumeration.Degree", degree).getId());
            }
            return ODFContentHelper.this._programDegrees.get(degree);
        }

        private List<String> _getDomainContentIds(List<String> domains) {
            ArrayList<String> domainIds = new ArrayList<String>();
            for (String currentDomain : domains) {
                if (!ODFContentHelper.this._programDomains.containsKey(currentDomain)) {
                    ODFContentHelper.this._programDomains.put(currentDomain, ODFContentHelper.this._odfReferenceTableHelper.getItemFromCode("odf-enumeration.Domain", currentDomain).getId());
                }
                domainIds.add(ODFContentHelper.this._programDomains.get(currentDomain));
            }
            return domainIds;
        }

        public ProgramBuilder withDefaultOrgUnits(OrgUnit ... defaultOrgUnits) {
            this._defaultOrgUnitIds = Arrays.stream(defaultOrgUnits).map(SimpleAmetysObject::getId).collect(Collectors.toList());
            return this;
        }

        @Override
        protected String _getContentType() {
            return "org.ametys.plugins.odf.Content.program";
        }

        @Override
        protected String _getDefaultTitle() {
            return "Program";
        }

        @Override
        protected String _getWorkflowName() {
            return "program";
        }
    }

    public class OrgUnitBuilder
    extends AbstractODFContentBuidler<OrgUnit, OrgUnitBuilder> {
        @Override
        protected Map<String, Object> _getContentValues(Map<String, Object> data) throws AmetysRepositoryException, WorkflowException {
            HashMap<String, Object> contentValues = new HashMap<String, Object>();
            block6: for (Map.Entry<String, Object> entry : data.entrySet()) {
                switch (entry.getKey()) {
                    case "childOrgUnits": {
                        List<String> childrenIds = this._getChildrenIds(data, this._catalogName);
                        contentValues.put("childOrgUnits", childrenIds);
                        continue block6;
                    }
                }
                contentValues.put(entry.getKey(), entry.getValue());
            }
            return contentValues;
        }

        private List<String> _getChildrenIds(Map<String, Object> data, String defaultCatalog) throws AmetysRepositoryException, WorkflowException {
            ArrayList<String> childrenIds = new ArrayList<String>();
            List dataChildren = (List)data.get("childOrgUnits");
            for (Object child : dataChildren) {
                if (child instanceof String) {
                    childrenIds.add((String)child);
                    continue;
                }
                if (child instanceof OrgUnit) {
                    childrenIds.add(((OrgUnit)child).getId());
                    continue;
                }
                Map dataChild = (Map)child;
                OrgUnit orgUnit = (OrgUnit)((OrgUnitBuilder)((OrgUnitBuilder)new OrgUnitBuilder().withDefaultCatalog(defaultCatalog)).fromJavaMap(dataChild)).build();
                childrenIds.add(orgUnit.getId());
            }
            return childrenIds;
        }

        @Override
        protected Map<String, Object> _getDefaultValues() {
            return Map.of("codeUAI", ODFContentHelper.DEFAULT_ORG_UNIT_CODE_UAI);
        }

        @Override
        protected String _getContentType() {
            return "org.ametys.plugins.odf.Content.orgunit";
        }

        @Override
        protected String _getDefaultTitle() {
            return "OrgUnit";
        }

        @Override
        protected String _getWorkflowName() {
            return "orgunit";
        }
    }
}

