/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const rightProfileDAO = Ametys.serviceManager.lookup("org.ametys.core.right.RightProfilesDAO");

logger.info("Add 'ODF_Rights_ProgramTree_RemoveElement' to all profiles with 'ODF_Rights_Program_Edit'");

let count = 0;
let profiles = rightProfileDAO.getProfiles()

for(let profile of profiles)
{
    let updated = false;
    let profileRights = rightProfileDAO.getRights(profile);
    
    if (profileRights.contains("ODF_Rights_Program_Edit") && !profileRights.contains("ODF_Rights_ProgramTree_RemoveElement"))
    {
        rightProfileDAO.addRight(profile, "ODF_Rights_ProgramTree_RemoveElement");
        count++;
    }
}

logger.info(`${count} profile(s) have been updated`);
