/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 * This button allows to search contents select some of them and reference them as given metadata of the selected content.
 * The catalog's criteria is forced to choose contents of a same catalog only.
 */
Ext.define('Ametys.plugins.odf.content.controller.AddExistingODFContentToCurrentSelectionButtonController', {
    extend: "Ametys.plugins.contentstree.AddExistingContentToCurrentSelectionButtonController",
   
    act: function(contentId, messageType)
    {
        // Get the catalog of the current content
        Ametys.data.ServerComm.callMethod({
            role: "org.ametys.odf.catalog.CatalogsManager",
            methodName: "getContentCatalog",
            parameters: [contentId],
            callback: {
                handler: this._getContentCatalogCb,
                scope: this,
                arguments: [contentId, messageType]
            },
            waitMessage: false
        });
    },
    
    /**
     * @private
     * Callback function invoked after retrieving the current catalog.
     * Search will be restricted to the contents of same catalog
     * @param {String} catalogName The catalog name
     * @param {Object[]} args The transmitted arguments
     * @param {String} args.0 The content identifier
     * @param {String} args.1 The message type
     */
    _getContentCatalogCb: function (catalogName, args)
    {
    	var searchModelParameters = this._getSearchModelParameters(args);
    	
        Ametys.cms.uihelper.SelectContentBySearch.open({
            modelId: this.getInitialConfig("searchModelId"),
            iconCls: this.getInitialConfig("boxIconCls"),
            icon: this.getInitialConfig("boxIcon") ? Ametys.CONTEXT_PATH + this.getInitialConfig("boxIcon") : null,
            title: this.getInitialConfig("boxTitle"),
            callback: Ext.bind(this._actCb, this, [args[0], args[1]], 1),
            helpmessage1: this.getInitialConfig("boxHelpMessage1"),
            helpmessage2: this.getInitialConfig("boxHelpMessage2"),
            multiple: this.getInitialConfig("allowMultipleSelection"),
            initSearchFn: Ext.bind(this._initCatalog, this, [catalogName], 1),
            searchModelParameters: searchModelParameters
        });
    },
    
    /**
     * @protected
     * Get the search model parameters
     * @param {Object[]} args The transmitted arguments
     */
    _getSearchModelParameters: function(args)
    {
    	return {};
    },
    
    /**
     * @private
     * Force the current calalog
     * @param {Ametys.form.ConfigurableFormPanel} form The search form
     * @param {String} catalogName The current catalog
     */
    _initCatalog: function (form, catalogName)
    {
        var catalogFd = form.getForm().findField(form.getFieldNamePrefix() + 'metadata-catalog-eq');
        if (catalogFd != null)
        {
            catalogFd.setValue(catalogName);
            catalogFd.setDisabled(true);
        }
    }
    
});
    