/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Singleton class for skills actions.
 * @private
 */
Ext.define('Ametys.plugins.odf.skills.SkillsActions', {
    singleton: true,
    
    /**
     * Exclude or include program items
     * @param {Ametys.ribbon.element.ui.ButtonController} controller the controller calling this function
     * @param {Boolean} state the press-state of the controller
     */
    setProgramItemsExclusion: function (controller, state)
    {
        var excluded = state;
        var contentIds = excluded ? controller.getIncludedProgramItemIds() : controller.getExcludedProgramItemIds();
        
        Ametys.data.ServerComm.callMethod({
            role: "org.ametys.odf.skill.ODFSkillsHelper",
            methodName: "setProgramItemsExclusion",
            parameters: [contentIds, excluded],
            callback: {
                handler: this._setProgramItemsExclusionCB,
                scope: this,
                arguments: []
            },
            waitMessage: true
        });
    },
    
    /**
     * Callback function after excluding or including the program items
     * @param {Object} response The server response
     */
    _setProgramItemsExclusionCB: function (response)
    {
        var programItems = response["allright-program-items"];
        if (programItems != null && programItems.length > 0)
        {
            var ids = [];
            for (var i = 0; i < programItems.length; i++) 
            {
                ids.push(programItems[i].id);
            }

            Ext.create("Ametys.message.Message", {
                type: Ametys.message.Message.MODIFIED,
                targets: {
                    id: Ametys.message.MessageTarget.CONTENT,
                    parameters: { 
                        ids: ids
                    }
                }
            });
        }
    }
});