<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:docbook="http://docbook.org/ns/docbook"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:cms="http://ametys.org/cms/3.0"
                xmlns:date="http://exslt.org/dates-and-times"
                exclude-result-prefixes="docbook">
    
    <xsl:template match="/view">
        <fo:root>
            <fo:layout-master-set>
                <!-- Master single columns -->
                <fo:simple-page-master master-name="page" page-width="210mm" page-height="297mm" margin-left="1cm" margin-right="1cm" margin-top="2cm" margin-bottom="2cm">
                    <fo:region-body margin-top="0cm" margin-bottom="1cm">
                        <xsl:call-template name="region-body-definition"/>
                    </fo:region-body>
                    <fo:region-before extent="1cm">
                        <xsl:call-template name="region-before-definition"/>
                    </fo:region-before>
                    <fo:region-after extent="0.5cm">
                        <xsl:call-template name="region-after-definition"/>
                    </fo:region-after>
                </fo:simple-page-master>
                
                <!-- Master 2 columns -->
                <fo:simple-page-master master-name="page-2-columns" page-width="210mm" page-height="297mm" margin-left="1cm" margin-right="1cm" margin-top="2cm" margin-bottom="2cm">
                    <fo:region-body margin-top="0cm" margin-bottom="1cm">
                        <xsl:call-template name="region-body-definition"/>
                    </fo:region-body>
                    <fo:region-before>
                        <xsl:call-template name="region-before-definition"/>
                    </fo:region-before>
                    <fo:region-after>
                        <xsl:call-template name="region-after-definition"/>
                    </fo:region-after>
                </fo:simple-page-master>
            </fo:layout-master-set>
            
            <!--  The bookmark tree -->
            <xsl:call-template name="bookmark-tree" />
            
            <!-- Contents -->
            <xsl:call-template name="contents"/>
        </fo:root>
    </xsl:template>
    
    <xsl:template name="bookmark-tree">
        <fo:bookmark-tree>
            <fo:bookmark internal-destination="bookmark-programItem-{/view/booklet/programItem/@id}">
                  <fo:bookmark-title><xsl:value-of select="/view/booklet/programItem/@title" /></fo:bookmark-title>
                  <xsl:if test="/view/booklet/subprogram">
                    <fo:bookmark internal-destination="bookmark-subprogram-{/view/booklet/subprogram/@id}">
                        <fo:bookmark-title><i18n:text i18n:key="PLUGINS_ODF_EDUCATIONAL_BOOKLET_PROGRAMITEM_PDF_BOOKMARK_SUBPROGRAMS" i18n:catalogue="plugin.odf"/></fo:bookmark-title>
                        <xsl:for-each select="/view/booklet/subprogram">
                            <fo:bookmark internal-destination="bookmark-{local-name()}-{@id}">
                               <fo:bookmark-title><xsl:value-of select="@title" /></fo:bookmark-title>
                            </fo:bookmark>
                        </xsl:for-each>
                    </fo:bookmark>
                  </xsl:if>
                  <xsl:if test="/view/booklet/course">
                      <fo:bookmark internal-destination="bookmark-course-{/view/booklet/course/@id}">>
                          <fo:bookmark-title><i18n:text i18n:key="PLUGINS_ODF_EDUCATIONAL_BOOKLET_PROGRAMITEM_PDF_BOOKMARK_COURSES" i18n:catalogue="plugin.odf"/></fo:bookmark-title>
                          <!-- Browse structure to represent the courses hierarchy -->
                          <xsl:apply-templates select="/view/structure/*/subprogram|/view/structure/*/container|/view/structure/*/courselist" mode="bookmark-tree"/>
                      </fo:bookmark>
                  </xsl:if>
            </fo:bookmark>
        </fo:bookmark-tree>
    </xsl:template>
    
    <xsl:template match="subprogram|container|courselist" mode="bookmark-tree">
        <xsl:apply-templates select="subprogram|container|courselist|course" mode="bookmark-tree"/>
    </xsl:template>
    
    <xsl:template match="course" mode="bookmark-tree">
        <xsl:variable name="id" select="@id"/>
        <!-- avoid duplicated entry for first level -->
        <xsl:if test="not(preceding::course[@id = $id]) and count(/view/booklet/course[@id = $id]/fo/fo:root/fo:page-sequence) > 0">
            <fo:bookmark internal-destination="bookmark-{local-name()}-{@id}">
               <fo:bookmark-title><xsl:value-of select="@title" /></fo:bookmark-title>
               
               <xsl:apply-templates select="courselist" mode="bookmark-tree"/>
            </fo:bookmark>
        </xsl:if>
    </xsl:template>
    
    <!-- +
         | Contents
         + -->
         
    <xsl:template name="contents">   
        <!-- First, root program item -->
        <xsl:apply-templates select="/view/booklet/programItem"/>
        <!-- Then sub programs -->
        <xsl:apply-templates select="/view/booklet/subprogram"/>
        <!-- Then courses -->
        <xsl:apply-templates select="/view/booklet/course"/>
    </xsl:template>
    
    <xsl:template match="programItem" mode="theEnd">
        <xsl:if test="not(/view/booklet/subprogram) and not(/view/booklet/course)">
            <fo:block id="theEnd"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="subprogram" mode="theEnd">
        <xsl:if test="not(/view/booklet/course)">
            <fo:block id="theEnd"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="course" mode="theEnd">
        <fo:block id="theEnd"/>
    </xsl:template>
    
    <xsl:template match="programItem|subprogram|course">
    
        <xsl:variable name="self" select="."/>
        <xsl:variable name="isLast" select="position() = last()"/>
        
        <xsl:for-each select="fo/fo:root/fo:page-sequence">
            <fo:page-sequence master-reference="{@master-reference}">
                <xsl:call-template name="xsl-region-before"/>
                <xsl:call-template name="xsl-region-after"/>
                    
                <fo:flow flow-name="xsl-region-body">
                
                    <xsl:if test="position() = 1">
                        <!-- Block for bookmark and anchors -->
                        <xsl:call-template name="bookmark-block" >
                            <xsl:with-param name="type" select="local-name($self)" />
                            <xsl:with-param name="id" select="$self/@id" />
                        </xsl:call-template>
                    </xsl:if>
            
                    <xsl:apply-templates select="fo:flow" />

                    <xsl:if test="$isLast and position() = last()">
                        <xsl:apply-templates select="$self" mode="theEnd"/>
                    </xsl:if>
                </fo:flow>
            </fo:page-sequence>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="fo:flow">
        <xsl:apply-templates select="fo:block[not(@id = 'theEnd')]" mode="content"/>
    </xsl:template>
    
    <xsl:template name="bookmark-block">
        <xsl:param name="type" />
        <xsl:param name="id" />
    
        <fo:block-container absolute-position="fixed" left="0in" top="0in" width="21cm" height="29.7cm">
            <fo:block id="bookmark-{$type}-{$id}"></fo:block>
       </fo:block-container>
    </xsl:template>
    
    <xsl:template match="@*|node()" mode="content">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" mode="content"/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="fo:block[@role = 'internal-chapter']" mode="content"/>
    
    <xsl:template match="fo:block[@role = 'heading']" mode="content">
        <xsl:variable name="ref"><xsl:call-template name="ahead-reference"/></xsl:variable>
        <ahead><xsl:value-of select="$ref"/></ahead>
        <fo:block/>
        
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" mode="content"/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template name="ahead-reference">
        <xsl:number level="multiple" count="programItem|course|fo:block[@role = 'heading']" format="1.1.1"/>
    </xsl:template>
    
    <xsl:template name="xsl-region-after">
        <fo:static-content flow-name="xsl-region-after">
            <fo:block margin-left="0cm" margin-right="0cm" margin-bottom="2cm">
                <xsl:call-template name="main-region-after-block"/>
                
                <fo:table table-layout="fixed" margin-top="0pt" padding="0pt">
                    <fo:table-column column-width="4cm"/>
                    <fo:table-column/>
                    <fo:table-column column-width="4cm"/>
                    
                    <fo:table-body>
                        <fo:table-row>
                            <xsl:call-template name="footer-page-number"/>
                            <xsl:call-template name="footer-text"/>
                            <xsl:call-template name="footer-logo"/>
                        </fo:table-row>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:static-content> 
    </xsl:template>
    
    <xsl:template name="footer-text">
        <fo:table-cell margin-left="0cm" padding="0" text-align="center" vertical-align="middle">
            <fo:block>
                <xsl:call-template name="footer-text-style"/>
                <xsl:call-template name="footer-catalog"/> 
                <xsl:call-template name="footer-version"/> 
            </fo:block>
        </fo:table-cell>
    </xsl:template>
    
    <xsl:template name="footer-version">
        <fo:block>
            <xsl:choose>
                <xsl:when test="/view/booklet/@isValidated = 'true'">
                    <i18n:text i18n:key="PLUGINS_ODF_EDUCATIONAL_BOOKLET_PROGRAMITEM_PDF_FOOTER_PAGE_ARCHIVE_DATE_TEXT" i18n:catalogue="plugin.odf"/>
                    <i18n:date-time pattern="dd/MM/yyyy à HH:mm" src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX"><xsl:value-of select="/view/booklet/@archiveDate"/></i18n:date-time>
                </xsl:when>
                <xsl:otherwise>
                    <i18n:text i18n:key="PLUGINS_ODF_EDUCATIONAL_BOOKLET_PROGRAMITEM_PDF_FOOTER_PAGE_DATE_TEXT" i18n:catalogue="plugin.odf"/>
                    <i18n:date-time pattern="dd/MM/yyyy à HH:mm" src-pattern="yyyy-MM-dd'T'HH:mm:ssXXX"><xsl:value-of select="date:date-time()"/></i18n:date-time>
                </xsl:otherwise>
            </xsl:choose>
        </fo:block>
    </xsl:template>
    
    <xsl:template name="footer-catalog">
        <fo:block><fo:inline font-weight="bold"><xsl:value-of select="/view/booklet/catalog"/></fo:inline></fo:block>
    </xsl:template>
    
    <xsl:template name="footer-page-number">
        <fo:table-cell vertical-align="middle" text-align="left" padding-left="1.5cm">
            <fo:block>
                <xsl:call-template name="footer-pages-style"/>
                <fo:page-number /> / <fo:page-number-citation ref-id="theEnd" />
            </fo:block>
        </fo:table-cell>
    </xsl:template>
    
    <xsl:template name="footer-logo">
        <fo:table-cell vertical-align="middle" text-align="right" padding-right="1.5cm">
            <fo:block></fo:block>
        </fo:table-cell>
    </xsl:template>
    
    <!-- +
         | Default styles
         + -->
    <xsl:template name="xsl-region-before">
        <fo:static-content flow-name="xsl-region-before">
              <fo:block-container absolute-position="fixed" left="0in" top="0in" width="21cm" height="29.7cm">
                  <fo:block/>
              </fo:block-container>
        </fo:static-content>
    </xsl:template>
    
    <xsl:template name="main-region-after-block">
        <xsl:attribute name="font-size">9px</xsl:attribute>
    </xsl:template>

    <xsl:template name="region-body-definition"/>
    
    <xsl:template name="region-before-definition"/>
    
    <xsl:template name="footer-pages-style"/>
    <xsl:template name="footer-text-style"/>
    <xsl:template name="footer-catalog-style"/>
    
    
    <xsl:template name="region-after-definition"/>

</xsl:stylesheet>