/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.cdmfr;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.activity.Initializable;

import org.ametys.cms.repository.DefaultContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.AbstractContentWorkflowComponent;
import org.ametys.odf.CallWSHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.program.Program;
import org.ametys.plugins.workflow.EnhancedFunction;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;

/**
 * This function calls a WS on remote server to delete a Program
 * This function should be executed as a post-function of "unpublish" action
 */
public class DeleteRemoteProgramFunction extends AbstractContentWorkflowComponent implements EnhancedFunction, Initializable
{
    private boolean _isActive;
    
    @Override
    public void initialize() throws Exception
    {
        _isActive = Config.getInstance().getValue("odf.publish.server");
    }

    @Override
    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException
    {
        if (!_isActive)
        {
            return;
        }
        
        // Retrieve current content
        WorkflowAwareContent content = getContent(transientVars);
        
        if (content instanceof Program)
        {
            Map<String, String> params = new HashMap<>();
            params.put(ProgramItem.CODE, ((Program) content).getCode());
            params.put(ProgramItem.CATALOG, ((Program) content).getCatalog());
            params.put(DefaultContent.METADATA_LANGUAGE, ((Program) content).getLanguage());
            
            // Delete program on remote application
            CallWSHelper.callWS("_odf-sync/delete-program", params, _logger);
        }
        
    }
    
    @Override
    public FunctionType getFunctionExecType()
    {
        return FunctionType.POST;
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf", "PLUGINS_ODF_DELETE_REMOTE_PROGRAM_FUNCTION_LABEL");
    }
}
