/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.course;

/**
 * Constants for shareable course
 */
public interface ShareableCourseConstants
{
    /** The metadata name for the shareable course composite */
    public static final String SHAREABLE_COURSE_COMPOSITE_METADATA = "shareable-workflow";
    
    /** The metadata name for the shareable course status */
    public static final String SHAREABLE_COURSE_STATUS_METADATA = "status";
    
    /** The attribute name for programs field */
    public static final String PROGRAMS_FIELD_ATTRIBUTE_NAME = "shareable-programs";
    
    /** The attribute name for periods field */
    public static final String PERIODS_FIELD_ATTRIBUTE_NAME = "shareable-periods";
    
    /** The attribute name for degrees field */
    public static final String DEGREES_FIELD_ATTRIBUTE_NAME = "shareable-degrees";
    
    /** The attribute name for orgunits field */
    public static final String ORGUNITS_FIELD_ATTRIBUTE_NAME = "shareable-orgunits";
}
