/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.program;

import javax.jcr.Node;

import org.ametys.odf.cdmfr.CDMFRTagsConstants;

/**
 * SubProgram java object
 */
public class SubProgram extends AbstractProgram<SubProgramFactory>
{
    /**
     * Constructor
     * @param node The JCR node
     * @param parentPath The parent path
     * @param factory the factory
     */
    public SubProgram(Node node, String parentPath, SubProgramFactory factory)
    {
        super(node, parentPath, factory);
    }
    
    // --------------------------------------------------------------------------------------//
    // CDMfr
    // --------------------------------------------------------------------------------------//
    @Override
    public String getCDMTagName()
    {
        return CDMFRTagsConstants.TAG_SUB_PROGRAM;
    }
}
