/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.program.properties;

import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.model.properties.AbstractContentProperty;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.program.SubProgramFactory;

/**
 * Property to get the parent subprograms of a program item or course part.
 */
public class ParentSubProgramsProperty extends AbstractContentProperty<Content>
{
    /** The ODF Helper */
    protected ODFHelper _odfHelper;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _odfHelper = (ODFHelper) manager.lookup(ODFHelper.ROLE);
    }
    
    @Override
    protected Set<? extends ModifiableContent> _getLinkedContents(Content content)
    {
        if (content instanceof ProgramItem programItem)
        {
            return _odfHelper.getParentSubPrograms(programItem, true);
        }
        if (content instanceof CoursePart coursePart)
        {
            return _odfHelper.getParentSubPrograms(coursePart, true);
        }
        return null;
    }
    
    @Override
    public boolean isMultiple()
    {
        return true;
    }

    public String getContentTypeId()
    {
        return SubProgramFactory.SUBPROGRAM_CONTENT_TYPE;
    }
}
