/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.rncp;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.ametys.core.ui.Callable;
import org.ametys.odf.program.SubProgram;

import com.google.common.collect.ImmutableMap;

/**
 * Client side element for subprogram RNCP sheets.
 */
public class RNCPSubProgramClientSideElement extends RNCPAbstractProgramClientSideElement
{
    /**
     * Get the list of available programs for the selected subprogram.
     * @param subProgramId The subprogram content ID
     * @return A JSON list with id and label of each matching program
     */
    @Callable
    public List<Map<String, String>> getAvailablePrograms(String subProgramId)
    {
        SubProgram subProgram = _resolver.resolveById(subProgramId);
        List<Map<String, String>> availablePrograms = _odfHelper.getParentPrograms(subProgram)
            .parallelStream()
            .map(p -> ImmutableMap.of("id", p.getId(), "label", p.getTitle()))
            .collect(Collectors.toList());
        return availablePrograms;
    }
}
