/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.workflow;

import java.util.Map;

import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.person.Person;
import org.ametys.odf.person.PersonFactory;
import org.ametys.runtime.i18n.I18nizableText;

import com.opensymphony.workflow.WorkflowException;

/**
 * OSWorkflow function for creating a {@link Person} content
 */
public class CreatePersonFunction extends AbstractCreateODFContentFunction
{
    /** Content name prefix for programs */
    public static final String CONTENT_NAME_PREFIX = "person-";
    /** Constant for storing the content name to use into the transient variables map. */
    public static final String IMPORT_MODE = CreatePersonFunction.class.getName() + "$importMode";
    
    @Override
    protected String _getContentNamePrefix()
    {
        return CONTENT_NAME_PREFIX;
    }
    
    @Override
    protected String _getObjectType(Map transientVars, Map args)
    {
        return PersonFactory.PERSON_NODETYPE;
    }
    
    @Override
    protected void _populateAdditionalData(Map transientVars, ModifiableContent content) throws WorkflowException
    {
        super._populateAdditionalData(transientVars, content);
        
        String value = (String) transientVars.get(IMPORT_MODE);
        if (value == null)
        {
            String contentTitle = _getNonNullVar(transientVars, CONTENT_TITLE_KEY, "Missing content title");
            content.setValue(Person.NAME, contentTitle);
        }
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf", "PLUGINS_ODF_CREATE_PERSON_FUNCTION_LABEL");
    }
}
