<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:exsl="http://exslt.org/common"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:ametys="org.ametys.cms.transformation.xslt.AmetysXSLTHelper"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    exclude-result-prefixes="i18n xalan resolver exsl">
    
    <xsl:import href="plugin:cms://pages/properties/view.xsl"/>

    <xsl:template match="/view">
        <xml>
            <xsl:call-template name="card"/>
            
            <xsl:call-template name="content-metadata"/>
            <xsl:call-template name="content-tags"/>
            
            <xsl:choose>
                <xsl:when test="odf/programItem">
                	<!-- References for ODF program items -->
                    <xsl:call-template name="program-item-paths"/>
		            <xsl:call-template name="program-item-children"/>
		            <xsl:call-template name="other-referencing-contents"/>
                </xsl:when>
                <xsl:otherwise>
                	<!-- References for others contents -->
		            <xsl:call-template name="referencing-contents"/>
                </xsl:otherwise>
            </xsl:choose>
        </xml>
    </xsl:template>
    
    <xsl:template name="program-item-paths">
        <xsl:if test="odf/programItem/ancestors">
            <div class="bloc ancestor-paths">
                <h1><i18n:text i18n:key="PLUGINS_ODF_UITOOL_DETAILS_ANCESTOR_PATHS" i18n:catalogue="plugin.odf"/></h1>
                <ul>
                    <xsl:for-each select="odf/programItem/ancestors/path">
                        <li>
                            <xsl:for-each select="item">
                                <xsl:choose>
                                    <xsl:when test="position() = last()">
	                                    <xsl:value-of select="."/> (<xsl:value-of select="@code"/>)
	                                </xsl:when>
	                                <xsl:otherwise>
	                                    <a href="{resolver:resolve('content', @id)}"><xsl:value-of select="."/> (<xsl:value-of select="@code"/>)</a>
	                                    <xsl:text> &gt; </xsl:text>
	                                </xsl:otherwise>
                                </xsl:choose>
                            </xsl:for-each>
                        </li>
                    </xsl:for-each>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="program-item-children">
        <xsl:if test="odf/programItem/children">
            <div class="bloc children">
                <h1><i18n:text i18n:key="PLUGINS_ODF_UITOOL_DETAILS_CHILDRENS" i18n:catalogue="plugin.odf"/></h1>
                <ul>
                    <xsl:for-each select="odf/programItem/children/item">
                        <xsl:sort select="."/>
                        <li>
                             <a href="{resolver:resolve('content', @id)}"><xsl:value-of select="."/> (<xsl:value-of select="@code"/>)</a>
                        </li>
                    </xsl:for-each>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="other-referencing-contents">
        <xsl:variable name="other-referencing-contents">
            <referencing-contents>
                <xsl:for-each select="content/referencing-contents/referencing-content">
                    <xsl:variable name="id" select="@id"/>
                    <xsl:if test="not(/view/odf/programItem/children/item[@id = $id]) and not(/view/odf/programItem/ancestors/path/item[@id = $id and (position() = last()-1)])">
                        <xsl:copy-of select="."/>
                    </xsl:if>
                </xsl:for-each>
            </referencing-contents>
        </xsl:variable>
        
        <xsl:if test="exsl:node-set($other-referencing-contents)/referencing-contents/referencing-content">
	        <div class="bloc referencing-contents">
	            <h1><i18n:text i18n:key="PLUGINS_ODF_UITOOL_DETAILS_OTHER_REFERENCING_CONTENTS" i18n:catalogue="plugin.odf"/></h1>
	            <ul>
			        <xsl:for-each select="exsl:node-set($other-referencing-contents)/referencing-contents/referencing-content">
                        <xsl:sort select="@title"/>
	                    <li><a href="{resolver:resolve('content', @id)}"><xsl:value-of select="@title"/></a></li>
			        </xsl:for-each>
	            </ul>
                <xsl:if test="content/referencing-contents/@hasOther = 'true'">
                    <em><i18n:text i18n:catalogue="plugin.cms" i18n:key="UITOOL_DETAILS_REFERENCING_CONTENTS_MORE"/></em>
                </xsl:if>
	        </div>
        </xsl:if>         
    </xsl:template>
    
</xsl:stylesheet>